<?php
/* $ars = array(
 * 'siteUrl' =>  'http://wordpress.stackexchange.com/',
  'siteName' =>  'Adl Plugin',
  'businessNiche' =>  'WordPress Plugin',
  'phoneNumber' =>  '017111111111',
  'emailAddress' =>  'my@gmail.com',
  'streetName' =>  'my address',
  'countryName' =>  'Bangladesh',
  'cityName' =>  'Sylhet Sadar',
  'stateName' =>  'Sylhet',
    'zipCode' =>  '3100',
    'mailingAddress' =>  'House no 55, Flat no 1A, New Lane, Dhaka.',
)
*/
//validate and sanitize data of general info
$siteUrl = (!empty($args['siteUrl'])) ? esc_url($args['siteUrl']) : get_site_url();
$siteName = (!empty($args['siteName'])) ? esc_attr($args['siteName']) : get_option('blogname');
$businessNiche = (!empty($args['businessNiche'])) ? esc_attr($args['businessNiche']) : '';
$phoneNumber = (!empty($args['phoneNumber'])) ? esc_attr($args['phoneNumber']) : '';
$emailAddress = (!empty($args['emailAddress'])) ? esc_attr($args['emailAddress']) : '';
$streetName = (!empty($args['streetName'])) ? esc_attr($args['streetName']) : '';
$countryName = (!empty($args['countryName'])) ? esc_attr($args['countryName']) : '';
$cityName = (!empty($args['cityName'])) ? esc_attr($args['cityName']) : '';
$stateName = (!empty($args['stateName'])) ? esc_attr($args['stateName']) : '';
$zipCode = (!empty($args['zipCode'])) ? esc_attr($args['zipCode']) : '';
$mailingAddress = (!empty($args['mailingAddress'])) ? esc_attr($args['mailingAddress']) : '';


//validate and sanitize data of Social info
$facebookUrl = (!empty($args['facebookUrl'])) ? esc_url($args['facebookUrl']) : '';
$googlePlusUrl = (!empty($args['googlePlusUrl'])) ? esc_url($args['googlePlusUrl']) : '';
$linkedInUrl = (!empty($args['linkedInUrl'])) ? esc_url($args['linkedInUrl']) : '';
$twitterUrl = (!empty($args['twitterUrl'])) ? esc_url($args['twitterUrl']) : '';

// validate and sanitize data of popup options
$disabled_pop_notice_title = (isset($args['disabled_pop_notice_title'])) ? absint($args['disabled_pop_notice_title']) : 0;
$popup_notice_title = (isset($args['popup_notice_title'])) ? sanitize_text_field($args['popup_notice_title']) : '';
$agreement_text = (isset($args['agreement_text'])) ? sanitize_text_field($args['agreement_text']) : '';
$accept_btn_text = (isset($args['accept_btn_text'])) ? sanitize_text_field($args['accept_btn_text']) : '';
$popup_width = (isset($args['popup_width'])) ? sanitize_text_field($args['popup_width']) : '90%';
$popup_height = (isset($args['popup_height'])) ? sanitize_text_field($args['popup_height']) : '90vh';
$user_can_close_popup = (isset($args['user_can_close_popup'])) ? absint($args['user_can_close_popup']) : 0;
$disabled_pop_js_css = (isset($args['disabled_pop_js_css'])) ? absint($args['disabled_pop_js_css']): 0;

// cache some reusable vars here
$cookie_display_position = !empty($cookie_display_position) ? $cookie_display_position : '';
$cookie_layout = !empty($cookie_layout) ? $cookie_layout : '';
?>


<!--Tab Legal page Home content-->
<h3 class="head text-center">Legal Page Home</h3>

<div class="container-fluid">
    <div class="row">

        <div class="col-sm-12">
            <!--home tab's tab menu-->
            <div class="btn-pref btn-group btn-group-justified btn-group-lg" role="group" aria-label="...">

                <div class="btn-group" role="group">
                    <button type="button" id="stars" class="btn btn-primary" href="#tab1" data-toggle="tab"><span class="glyphicon glyphicon-star" aria-hidden="true"></span>
                        <div class="hidden-xs">General Information</div>
                    </button>
                </div>
                <div class="btn-group" role="group">
                    <button type="button" id="favorites" class="btn btn-default" href="#tab2" data-toggle="tab"><span class="glyphicon glyphicon-envelope" aria-hidden="true"></span>
                        <div class="hidden-xs">Social Information</div>
                    </button>
                </div>
                <div class="btn-group" role="group">
                    <button type="button" id="following" class="btn btn-default" href="#tab3" data-toggle="tab"><span class="glyphicon glyphicon-modal-window" aria-hidden="true"></span>
                        <div class="hidden-xs">Popup Settings</div>
                    </button>
                </div>
                <div class="btn-group" role="group">
                    <button type="button" id="following" class="btn btn-default" href="#tab4" data-toggle="tab"><span class="glyphicon glyphicon-globe" aria-hidden="true"></span>
                        <div class="hidden-xs">Cookies Bar Settings</div>
                    </button>
                </div>

                <div class="btn-group" role="group">
                    <button type="button" id="following" class="btn btn-default" href="#tab5" data-toggle="tab"><span class="glyphicon glyphicon-wrench" aria-hidden="true"></span>
                        <div class="hidden-xs">Miscellaneous Settings</div>
                    </button>
                </div>


            </div>  <!--ends btn-pref-->


            <!--Home tab's tab content-wrapper -->
            <div class="well">

                <div class="tab-content">
                    <div class="tab-pane fade in active" id="tab1">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-8 col-md-offset-2">
                                    <form class="form-horizontal" method="post" id="adl_lp_gs_form">
                                        <div class="form-group">
                                            <label for="siteUrl" class="col-sm-3 control-label">Your Site URL</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="siteUrl" class="form-control" id="siteUrl" placeholder="http://example.com" value="<?= $siteUrl; ?>" >
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [siteUrl]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="siteName" class="col-sm-3 control-label">Site / Business Name</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="siteName" class="form-control" id="siteName" placeholder="Your Business Name" value="<?= $siteName; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [siteName]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="businessNiche" class="col-sm-3 control-label">Business Niche</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="businessNiche" class="form-control" id="businessNiche" placeholder="Your Business Niche" value="<?= $businessNiche; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [businessNiche]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="phoneNumber" class="col-sm-3 control-label">Phone Number</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="phoneNumber" class="form-control" id="phoneNumber" placeholder="eg +440123456789" value="<?= $phoneNumber; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label text-left">
                                                [phoneNumber]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="emailAddress" class="col-sm-3 control-label">Email Address</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="emailAddress" class="form-control" id="emailAddress" placeholder="eg mail@example.com" value="<?= $emailAddress; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label text-left">
                                                [emailAddress]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="streetName" class="col-sm-3 control-label">Street Name</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="streetName" class="form-control" id="streetName" placeholder="eg. 123 Street Name" value="<?= $streetName; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [streetName]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="countryName" class="col-sm-3 control-label">Country Name</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="countryName" class="form-control" id="countryName" placeholder="eg. USA" value="<?= $countryName; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [countryName]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="cityName" class="col-sm-3 control-label">City</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="cityName" class="form-control" id="cityName" placeholder="eg, Buffalo" value="<?= $cityName; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [cityName]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="stateName" class="col-sm-3 control-label">State</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="stateName" class="form-control" id="stateName" placeholder="eg. New York" value="<?= $stateName; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [stateName]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="zipCode" class="col-sm-3 control-label">Zip/Postal Code</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="zipCode" class="form-control" id="zipCode" placeholder="eg. 10001" value="<?= $zipCode; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [zipCode]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="mailingAddress" class="col-sm-3 control-label">Complete Mailing Address</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="mailingAddress" class="form-control" id="mailingAddress" placeholder="eg. 1115 Pleasant Valley Rd, Merlin, OR, 97532" value="<?= $mailingAddress; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [mailingAddress]
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-sm-1 col-sm-offset-3 control-label">
                                                <button type="submit" id="adl_lp_g_settings" name="adl_lp_g_settings" class="btn btn-primary" value="save">Save</button>
                                            </div>
                                            <div class="col-sm-1 control-label" id="adl_ajax_loader">
                                                <button type="reset" id="adl_lp_g_settings_reset" name="adl_lp_g_settings_reset"class="btn btn-primary" value="reset">Reset Fields</button>
                                            </div>
                                            <div class="col-sm-2 col-sm-offset-2 control-label" id="adl_ajax_loader">
                                                <button type="reset" id="adl_lp_g_settings_resetdb" name="adl_lp_g_settings_resetdb"class="btn btn-primary" value="resetdb">Reset Saved Data</button>
                                            </div>

                                        </div>
                                        <?php wp_nonce_field( $ADL_LP->nonceAction(), $ADL_LP->nonceName());?>

                                    </form>


                                </div>

                            </div>
                        </div>

                    </div> <!--ends #tab2--> <!-- general info content -->

                    <div class="tab-pane fade in" id="tab2">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-8 col-md-offset-2">
                                    <form class="form-horizontal" method="post" id="socialInfoForm">

                                        <div class="form-group">
                                            <label for="facebookUrl" class="col-sm-3 control-label">Facebook Page/Profile URL</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="facebookUrl" class="form-control" id="facebookUrl" placeholder="https://facebook.com/yourbusinessName" value="<?= $facebookUrl; ?>" >
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [facebookUrl]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="googlePlusUrl" class="col-sm-3 control-label">Google Plus URL</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="googlePlusUrl" class="form-control" id="googlePlusUrl" placeholder="https://google-plus.com/yourbusinessName" value="<?= $googlePlusUrl; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [googlePlusUrl]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="linkedInUrl" class="col-sm-3 control-label">LinkedIn Profile URL</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="linkedInUrl" class="form-control" id="linkedInUrl" placeholder="https://facebook.com/yourbusinessName" value="<?= $linkedInUrl; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [linkedInUrl]
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="twitterUrl" class="col-sm-3 control-label">Twitter URL</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="twitterUrl" class="form-control" id="twitterUrl" placeholder="https://twitter.com/yourbusinessName" value="<?= $twitterUrl; ?>">
                                            </div>
                                            <div class="col-sm-2 control-label">
                                                [twitterUrl]
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-sm-1 col-sm-offset-3 control-label">
                                                <button type="submit" class="btn btn-primary" value="SaveSocialInfo" id="social_info_submit">Save</button>
                                            </div>
                                            <div class="col-sm-1 control-label" id="adl_ajax_loader">
                                                <button type="reset" id="adl_lp_s_settings_reset" name="adl_lp_s_settings_reset"class="btn btn-primary" value="reset">Reset Fields</button>
                                            </div>
                                            <div class="col-sm-2 col-sm-offset-2 control-label" id="adl_ajax_loader">
                                                <button type="reset" id="adl_lp_s_settings_resetdb" name="adl_lp_s_settings_resetdb"class="btn btn-primary" value="resetdb">Reset Saved Data</button>
                                            </div>
                                        </div>

                                        <?php wp_nonce_field( $ADL_LP->nonceAction(), $ADL_LP->nonceName());?>

                                    </form>

                                </div>  <!--    ends .col-md-8-->

                            </div> <!--    ends .row -->
                        </div> <!--    ends .container -->


                    </div> <!--ends #tab2--> <!-- Social info content -->

                    <div class="tab-pane fade in " id="tab3">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-8 col-md-offset-2">
                                    <form class="form-horizontal" method="post" id="adl_lp_popup_form">
                                        <!--Disable Popup Notice Title-->
                                        <div class="form-group">
                                            <label for="popup_height" class="col-sm-3 control-label">Disable Popup Notice Title</label>
                                            <div class="col-sm-7">
                                                <div class="checkbox">
                                                    <label>
                                                        <input type="checkbox" name="disabled_pop_notice_title" value="1" <?php checked(@$args['disabled_pop_notice_title']); ?> > Yes, Disable it.
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="popup_notice_title" class="col-sm-3 control-label">Popup Notice Title</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="popup_notice_title" class="form-control" id="popup_notice_title" placeholder="eg. Please read and agree to the following terms to see the content" value="<?= @$popup_notice_title; ?>" >
                                            </div>

                                        </div>


                                        <div class="form-group">
                                            <label for="agreement_text" class="col-sm-3 control-label">Agreement Text</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="agreement_text" class="form-control" id="agreement_text" placeholder="eg. I have read and I agree" value="<?= @$agreement_text; ?>">
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="accept_btn_text" class="col-sm-3 control-label">Accept Button Text</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="accept_btn_text" class="form-control" id="accept_btn_text" placeholder="eg. Accept or Agree etc." value="<?= @$accept_btn_text; ?>">
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label for="popup_width" class="col-sm-3 control-label">Popup Width</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="popup_width" class="form-control" id="popup_width" placeholder="Eg. 90% or 800px" value="<?= @$popup_width; ?>">
                                            </div>

                                        </div>

                                        <div class="form-group">
                                            <label for="popup_height" class="col-sm-3 control-label">Popup Height</label>
                                            <div class="col-sm-7">
                                                <input type="text" name="popup_height" class="form-control" id="popup_height" placeholder="Eg. 100vh or 90% or 600px" value="<?= @$popup_height; ?>">
                                            </div>

                                        </div>


                                        <!--Allow user to close popup-->
                                        <div class="form-group">
                                            <label for="popup_height" class="col-sm-3 control-label">Allow user to close popup</label>
                                            <div class="col-sm-7">
                                                <div class="checkbox">
                                                    <label>
                                                        <input type="checkbox" name="user_can_close_popup" value="1" <?php checked(@$args['user_can_close_popup']); ?> > Allow user close the popup notice without agreeing to the term ?
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <!--Disable Popup JS & CSS-->
                                        <div class="form-group">
                                            <label for="popup_height" class="col-sm-3 control-label">Disable Popup JS & CSS</label>
                                            <div class="col-sm-7">
                                                <div class="checkbox">
                                                    <label>
                                                        <input type="checkbox" name="disabled_pop_js_css" value="1" <?php checked(@$args['disabled_pop_js_css']); ?> > Disable popups CSS and JS ( if your theme already has bootstrap to prevent conflict.)
                                                    </label>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <div class="col-sm-1 col-sm-offset-3 control-label">
                                                <button type="submit" id="adl_lp_pop_settings" name="adl_lp_pop_settings" class="btn btn-primary" value="save">Save</button>
                                            </div>
                                            <div class="col-sm-1 control-label" id="adl_ajax_loader">
                                                <button type="reset" id="adl_lp_pop_settings_reset" name="adl_lp_pop_settings_reset"class="btn btn-primary" value="reset">Reset Fields</button>
                                            </div>
                                            <div class="col-sm-2 col-sm-offset-2 control-label" id="adl_ajax_loader">
                                                <button type="reset" id="adl_lp_pop_settings_resetdb" name="adl_lp_pop_settings_resetdb"class="btn btn-primary" value="resetdb">Reset Saved Data</button>
                                            </div>

                                        </div>
						                <?php wp_nonce_field( $ADL_LP->nonceAction(), $ADL_LP->nonceName());?>

                                    </form>


                                </div>

                            </div>
                        </div>

                    </div> <!--ends #tab3--> <!-- Popup content -->

                    <div class="tab-pane fade in" id="tab4">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-6 col-md-offset-4">
                                    <form class="form-horizontal" method="post" id="cookie_form">




                                        <div class="form-group">
                                            <label for="show_cookie_warning"><?php esc_html_e('Show EU Cookie Alert/Notification to your users', ADL_LP_TEXTDOMAIN); ?></label>
                                            <input type="checkbox" class="form-control" id="show_cookie_warning" name="lp_cookie[show_cookie_warning]" value="1" <?php checked(@$args['show_cookie_warning']); ?> >
                                        </div>



                                        <div class="form-group">
                                            <label for="cookie_display_position">
                                                <?php esc_html_e('Cookie Bar Display Position', ADL_LP_TEXTDOMAIN); ?>
                                            </label>
                                            <select name="lp_cookie[cookie_display_position]" id="cookie_display_position">
                                                <option value=""><?php esc_html_e('Select Cookie Position', ADL_LP_TEXTDOMAIN); ?></option>
                                                <option value="bottom" <?php selected('bottom', $cookie_display_position); ?>>
                                                    <?php esc_html_e('At Bottom (Bar Style)', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                                <option value="bottom-left" <?php selected('bottom-left', $cookie_display_position); ?>>
                                                    <?php esc_html_e('At Bottom-Left (Floating Box)', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                                <option value="bottom-right" <?php selected('bottom-right', $cookie_display_position); ?>>
                                                    <?php esc_html_e('At Bottom-Right (Floating Box)', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                                <option value="top" <?php selected('top', $cookie_display_position); ?>>
                                                    <?php esc_html_e('At Top (Bar style)', ADL_LP_TEXTDOMAIN); ?>
                                                </option>

                                                <option value="top-left" <?php selected('top-left', $cookie_display_position); ?>>
                                                    <?php esc_html_e('At Top-Left(Floating Box)', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                                <option value="top-right" <?php selected('top-right', $cookie_display_position); ?>>
                                                    <?php esc_html_e('At Top-Right(Floating Box)', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                            </select>


                                        </div>


                                        <div class="form-group">
                                            <label for="cookie_layout">
                                                <?php esc_html_e('Cookie Bar Layout', ADL_LP_TEXTDOMAIN); ?>
                                            </label>
                                            <select name="lp_cookie[cookie_layout]" id="cookie_layout">
                                                <option value=""><?php esc_html_e('Select Cookie Layout', ADL_LP_TEXTDOMAIN); ?></option>
                                                <option value="block" <?php selected('block', $cookie_layout); ?>>
                                                    <?php esc_html_e('Block', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                                <option value="classic" <?php selected('classic', $cookie_layout); ?>>
                                                    <?php esc_html_e('Classic', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                                <option value="edgeless" <?php selected('edgeless', $cookie_layout); ?>>
                                                    <?php esc_html_e('Edgeless', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                                <option value="wire" <?php selected('wire', $cookie_layout); ?>>
                                                    <?php esc_html_e('Wire', ADL_LP_TEXTDOMAIN); ?>
                                                </option>
                                            </select>


                                        </div>

                                        <div class="form-group">
                                            <label for="cookie_policy_link"><?php esc_html_e('Cookie policy link', ADL_LP_TEXTDOMAIN); ?></label>
                                            <input type="text" class="form-control" id="cookie_policy_link" name="lp_cookie[cookie_policy_link]" value="https://cookiesandyou.com" placeholder="eg. https://cookiesandyou.com"  >
                                        </div>


                                        <!--Cookie Message-->
                                        <div class="form-group">
                                            <label for="cookie_message"><?php esc_html_e('Cookie Message', ADL_LP_TEXTDOMAIN); ?></label>
                                            <textarea class="form-control" placeholder="eg. This website uses cookie....." id="cookie_message" name="lp_cookie[cookie_message]" >This website uses cookies to ensure you get the best experience on our website</textarea>
                                        </div>

                                        <div class="form-group">
                                            <label for="cookie_message_bg"><?php esc_html_e('Cookie Message/Banner Background', ADL_LP_TEXTDOMAIN); ?></label>
                                            <input type="text" class="form-control lp-color-picker" id="cookie_message_bg" name="lp_cookie[cookie_message_bg]" value="#000000" >
                                        </div>

                                        <div class="form-group">
                                            <label for="cookie_message_color"><?php esc_html_e('Cookie Message/Banner Color', ADL_LP_TEXTDOMAIN); ?></label>
                                            <input type="text" class="form-control lp-color-picker" id="cookie_message_color" name="lp_cookie[cookie_message_color]" value="#ffffff" >
                                        </div>


                                        <!--Dismiss Button-->
                                        <div class="form-group">
                                            <label for="cookie_button"><?php esc_html_e('Cookie Button Text', ADL_LP_TEXTDOMAIN); ?></label>
                                            <input type="text" class="form-control" id="cookie_button" name="lp_cookie[cookie_button]" value="Dismiss" placeholder="eg. Dismiss or Got it etc."  >
                                        </div>

                                        <div class="form-group">
                                            <label for="cookie_button_bg"><?php esc_html_e('Dismiss Button Background', ADL_LP_TEXTDOMAIN); ?></label>
                                            <input type="text" class="form-control lp-color-picker" id="cookie_button_bg" name="lp_cookie[cookie_read_more_link]" value="#f1d600"  >
                                        </div>

                                        <div class="form-group">
                                            <label for="cookie_button_text_color"><?php esc_html_e('Dismiss Button Text Color', ADL_LP_TEXTDOMAIN); ?></label>
                                            <input type="text" class="form-control lp-color-picker" id="cookie_button_text_color" name="lp_cookie[cookie_button_text_color]" value="#000"  >
                                        </div>



                                        <div class="form-group">
                                            <div class="col-sm-1 col-sm-offset-3 control-label">
                                                <button type="submit" class="btn btn-primary" id="cookie_setting_submit">Save</button>
                                            </div>
                                        </div>
                                        <?php wp_nonce_field( $ADL_LP->nonceAction(), $ADL_LP->nonceName());?>
                                    </form>

                                </div>  <!--    ends .col-md-6-->


                            </div> <!--    ends .row -->
                        </div> <!--    ends .container -->

                    </div> <!--ends #tab4-->  <!-- Cookie  info content -->

                    <div class="tab-pane fade in" id="tab5">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-6 col-md-offset-4">
                                    <form class="form-horizontal" method="post" id="misc_form">

                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="hide_lp_in_search" value="1" <?php checked(@$args['hide_lp_in_search']); ?> > Exclude legal pages in Search Result
                                            </label>
                                        </div>


                                        <div class="checkbox">
                                            <label style="color: red;">
                                                <input  type="checkbox" name="delete_adl_lp_data" value="1" <?php checked(@$args['delete_adl_lp_data']); ?> > Warning!! Check this to remove plugin's data on uninstall ( Check it ONLY IF YOU UNDERSTAND what you are doing.)
                                            </label>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-sm-1 col-sm-offset-3 control-label">
                                                <button type="submit" class="btn btn-primary" id="misc_setting_submit">Save</button>
                                            </div>
                                        </div>
                                        <?php wp_nonce_field( $ADL_LP->nonceAction(), $ADL_LP->nonceName() );?>
                                    </form>

                                </div>  <!--    ends .col-md-6-->


                            </div> <!--    ends .row -->
                        </div> <!--    ends .container -->

                    </div> <!--ends #tab5-->  <!-- Miscellaneous  info content -->



                </div>

            </div>   <!--    ends .well-->


        </div> <!--ends col-sm-12  HOME TAB-->







    </div>
</div>