<?php
/**
 * ReportAbuse:- Message filter.
 *
 * @package    ReportAbuse
 * @subpackage group
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Message\Filters;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter Group Query.
 */
class Message_Filter {

	/**
	 * User settings.
	 *
	 * @var array
	 */
	private $settings = array();

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		$this->settings = array(
			'auto_hide' => bpmts_get_option( 'bp_group_auto_hide', 0 ),
			'hide_type' => bpmts_get_option( 'bp_group_hide_type', array( 'all' ) ),
		);
	}

}
