<?php
/**
 * Forum UI Helper.
 *
 * @package    BuddyPressModerationTools
 * @subpackage BBPress\Forum
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BBPress\Forum\Handlers;

// Exit if files access directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Buttons & Messages management.
 */
class Forum_UI_Helper {

	/**
	 * Item type.
	 *
	 * @var string
	 */
	private $item_type = '';

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self            = new self();
		$self->item_type = bbp_get_forum_post_type();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		// filter body.
		if ( is_user_logged_in() && is_super_admin() ) {
			add_filter( 'body_class', array( $this, 'add_body_class' ) );
			add_filter( 'post_class', array( $this, 'add_list_class' ) );
		}

		// Add Buttons.
		add_filter( 'the_title', array( $this, 'add_report_buttons' ), 1001 );
	}


	/**
	 * Add appropriate class to body.
	 *
	 * @param array $classes css classes.
	 *
	 * @return array
	 */
	public function add_body_class( $classes ) {

		if ( ! is_user_logged_in() ) {
			return $classes;
		}

		if ( is_singular( $this->item_type ) ) {
			$classes[] = bpmts_is_item_hidden( get_queried_object_id(), $this->item_type ) ? "bpmts-displayed-item-hidden bpmts-displayed-{$this->item_type}-hidden" : "bpmts-displayed-item-clean bpmts-displayed-{$this->item_type}-clean";
		}

		return $classes;
	}

	/**
	 * Add extra class to member list entry.
	 *
	 * @param array $classes classes.
	 *
	 * @return array
	 */
	public function add_list_class( $classes ) {
		$classes[] = bpmts_is_item_hidden( get_the_ID(), $this->item_type ) ? "bpmts-item-entry-hidden bpmts-bbp-entry-{$this->item_type}-hidden" : "bpmts-item-entry-clean bpmts-bbp-entry-{$this->item_type}-clean";

		return $classes;
	}

	/**
	 * Add button to single member header.
	 *
	 * @param string $title forum title.
	 *
	 * @return string
	 */
	public function add_report_buttons( $title ) {

		if ( is_admin() ) {
			return $title;
		}

		if ( get_post_type() === $this->item_type && bpmts_user_can_report() ) {
			$title .= bpmts_get_report_button(
				array(
					'item_id'    => get_the_ID(),
					'item_type'  => $this->item_type,
					'context'    => $this->item_type,
					'context_id' => get_the_ID(),
				)
			);
		}

		return $title;
	}
}
