<?php
/**
 * Admin Settings Pages for the Forum.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BBPress\Forum
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BBPress\Forum\Admin;

use Press_Themes\PT_Settings\Panel;

// Exit if the file is accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Forum_Settings_Panel {

	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$defaults = bpmts_get_default_settings();

		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/forum-moderation-settings/';
		$panel->add_section( 'report-forum-general-settings', __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => 'bbp_forum_auto_hide',
			      'label'   => __( 'Auto hide forum?', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults['bbp_forum_auto_hide'],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'If enabled, reported forums will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bbp_forum_threshold',
			      'label'   => __( 'Forum hiding threshold ', 'buddypress-moderation-tools' ),
			      'type'    => 'number',
			      'default' => $defaults['bbp_forum_threshold'],
			      'desc'    => __( 'How many users should report the forum before it gets hidden?', 'buddypress-moderation-tools' ),
		      ) )
		      ->add_field( array(
			      'name'    => 'bbp_forum_hide_type',
			      'label'   => __( 'Hide forum for', 'buddypress-moderation-tools' ),
			      'type'    => 'multicheck',
			      'default' => $defaults['bbp_forum_hide_type'],
			      'options' => array(
				      'all'      => __( 'All when threshold is reached.', 'buddypress-moderation-tools' ),
				      'reporter' => __( 'Reporters when they report the activity', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => __( 'Enable auto hiding of forum for the reporters or all users when threshold is reached.', 'buddypress-moderation-tools' ),
		      ) );

		// Notification.
		$section = $panel->add_section( 'report-forum-new-report-admin-notification', __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_forum_notify_admin_on_report',
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_forum_notify_admin_on_report'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Notify admin if a forum is reported.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_forum_admin_reported_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_forum_admin_reported_subject'],
		) )->add_field( array(
			'name'    => 'bbp_forum_admin_reported_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_forum_admin_reported_message'],
		) );

		// Notification.
		$section = $panel->add_section( 'report-forum-admin-threshold-notification', __( 'Admin notification on hiding forum', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_forum_notify_admin_on_hide',
			'label'   => __( 'Notify admin when forum is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_forum_notify_admin_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'Admin will only be notified when a forum is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_forum_admin_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_forum_admin_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bbp_forum_admin_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_forum_admin_hidden_message'],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( 'report-forum-user-threshold-notification', __( 'User notification on hiding forum', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_forum_notify_user_on_hide',
			'label'   => __( 'Notify forum owner when their forum is hidden?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_forum_notify_user_on_hide'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their forum is hidden.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_forum_user_hidden_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_forum_user_hidden_subject'],
		) )->add_field( array(
			'name'    => 'bbp_forum_user_hidden_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_forum_user_hidden_message'],
		) );

		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-forum-user-notification-activity-restore', __( 'User notification on restoring forum', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_forum_notify_user_on_restore',
			'label'   => __( 'Notify forum creator when their forum is restored?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_forum_notify_user_on_restore'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'forum creator will be notified when their forum is restored.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_forum_user_restored_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_forum_user_restored_subject'],
		) )->add_field( array(
			'name'    => 'bbp_forum_user_restored_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_forum_user_restored_message'],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( 'report-forum-notification-forum-delete', __( 'User notification on forum delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => 'bbp_forum_notify_user_on_delete',
			'label'   => __( 'Notify user when their forum is deleted?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults['bbp_forum_notify_user_on_delete'],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => __( 'User will be notified when their forum is deleted by admin.', 'buddypress-moderation-tools' ),
		) );

		$section->add_field( array(
			'name'    => 'bbp_forum_user_deleted_subject',
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults['bbp_forum_user_deleted_subject'],
		) )->add_field( array(
			'name'    => 'bbp_forum_user_deleted_message',
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults['bbp_forum_user_deleted_message'],
		) );
	}
}

