<?php
/**
 * Reportable Interface
 *
 * @package    ReportAbuse
 * @subpackage Reportable
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Contracts;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Reportable Interface
 */
interface Reportable {

	/**
	 * Is this a valid reportable item.
	 *
	 * @param int    $item_id reportable item id.
	 * @param string $context reporting context(e.g post,groups etc).
	 * @param int    $context_id context id(post id, group id).
	 *
	 * @return bool
	 */
	public function is_valid( $item_id, $context, $context_id );

	/**
	 * Report an item. Adds to queue.
	 *
	 * @param int    $item_id reportable item id.
	 * @param string $context reporting context(e.g post,groups etc).
	 * @param int    $context_id context id(post id, group id).
	 *
	 * @return bool
	 */
	public function report( $item_id, $context, $context_id );
}
