<?php
/**
 * Single Queue entry.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Admin/Queue
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

?>
<div class="wrap">
	<h1 class="wp-heading-inline"><span
			class="bpmts-title-type"><?php printf( "Reported %s:", $reportable->label ); ?></span> <?php echo wp_kses_data( $reportable->get_item_title( $entry->item_id ) ); ?>
		<a class="page-title-action bpmts-title-action-view"
		   href="<?php echo esc_url( $reportable->get_item_permalink( $entry->item_id ) ); ?>"> <?php _e( 'View', 'buddypress-moderation-tools' ); ?></a>
		<a class="page-title-action bpmts-title-action-edit"
		   href="<?php echo esc_url( $reportable->get_item_edit_url( $entry->item_id ) ); ?>"> <?php _e( 'Edit', 'buddypress-moderation-tools' ); ?></a>
		<a class="page-title-action bpmts-title-action-delete"
		   href="<?php echo esc_url( $reportable->get_item_delete_url( $entry->item_id ) ); ?>" title="<?php _e( 'Be careful. It may result in removal of content permanently.', 'buddypress-moderation-tools' );?>"> <?php _e( 'Delete', 'buddypress-moderation-tools' ); ?></a>
	</h1>
	<?php echo $reportable->get_item_display_card( $entry->item_id ); ?>

	<hr class="wp-header-end">
	<?php bpmts_admin_notice(); ?>
	<form method="get" action="">
		<?php
		$table = $this->table;
		$table->views();
		$table->prepare_items();
		$table->display();
		$this->hidden_fields();
		wp_nonce_field( 'bpmtp-reports-action', '_bpmtp_reports_nonce' );
		?>
	</form>
</div>
