<?php
/**
 * Single Log entry.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Admin/Log
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

$item_id = $queue->item_id;
?>
<div class="wrap">
	<h1 class="wp-heading-inline"><span class="bpmts-title-type"><?php printf( __( 'Reported %s:', 'buddypress-moderation-tools' ), $reportable->label ); ?></span> <?php echo wp_kses_data( $reportable->get_item_title( $queue->item_id ) ); ?>
		<a class="page-title-action bpmts-title-action-view" href="<?php echo esc_url( $reportable->get_item_permalink( $item_id ) ); ?>"> <?php _e( 'View', 'buddypress-moderation-tools' ); ?></a>
		<a class="page-title-action bpmts-title-action-edit" href="<?php echo esc_url( $reportable->get_item_edit_url( $item_id ) ); ?>"> <?php _e( 'Edit', 'buddypress-moderation-tools' ); ?></a>
		<a class="page-title-action bpmts-title-action-delete" href="<?php echo esc_url( $reportable->get_item_delete_url( $item_id ) ); ?>"> <?php _e( 'Delete', 'buddypress-moderation-tools' ); ?></a>
	</h1>

	<div class='bpmts-item-card bpmts-user-card bpmts-clearfix'>
	<div class='bpmts-item-thumbnail bpmts-type-<?php echo esc_attr($reportable->type);?>-avatar'><?php echo  $reportable->get_item_thumbnail( $item_id, 'thumb' );?></div>
	<div class='bpmts-item-details'>
	<div class='bpmts-item-title bpmts-type-<?php echo esc_attr( $reportable->type);?>-title'><?php echo wp_kses_data( $reportable->get_item_title( $item_id ) );?></div>
	<div class='bpmts-item-description bpmts-type-<?php echo esc_attr($reportable->type);?>-description'><?php echo wp_kses_data( $reportable->get_item_description( $item_id ) );?></div>
        <div class='bpmts-item-actions'>
            <strong><?php _e( 'Moderation Action', 'buddypress-moderation-tools' );?></strong>
            <br/>
            <?php echo wp_kses_data( $entry->message );?>
        </div>

	<div class='bpmts-item-footer'>

		<ul>

		<li> <?php printf( __( 'Type: <span> %s</span>', 'buddypress-moderation-tools' ), $reportable->label ) ;?></li>
		<li> <?php printf( __( 'Total Reports: <span> %d</span>', 'buddypress-moderation-tools' ), $queue->total_reports_count ) ;?> </li>
		<li> <?php printf( __( 'New Reports: <span> %d</span>', 'buddypress-moderation-tools' ), $queue->current_reports_count );?> </li>

			<?php if ( $queue->is_hidden ): ?>
                <li><?php echo __( 'State: <span>Hidden</span>', 'buddypress-moderation-tools' ); ?> </li>
			<?php else : ?>
                <li><?php echo __( 'State: <span>Visible</span>', 'buddypress-moderation-tools' ); ?></li>
			<?php endif; ?>

		<li> <?php printf( __( 'First reported on: <span> %s</span>', 'buddypress-moderation-tools' ), mysql2date( 'F j, Y',  $queue->created_at ) ) ;?></li>
		<li><?php printf( __( 'Last reported on: <span> %s</span>', 'buddypress-moderation-tools' ), mysql2date( 'F j, Y',  $queue->updated_at ) ); ?></li>
		<li><?php printf( __( 'Moderated on: <span> %s</span>', 'buddypress-moderation-tools' ), mysql2date( 'F j, Y',  $entry->updated_at ) ); ?></li>

		</ul>

	</div>
	</div>
	<hr class="wp-header-end">
	<?php bpmts_admin_notice(); ?>
	<form method="get">
		<?php
		$table = $this->table;
		$table->views();
		$table->prepare_items();
		$table->display();
		$this->hidden_fields();
		wp_nonce_field( 'bpmtp-reports-action', '_bpmtp_reports_nonce' );
		?>
	</form>
</div>
