<?php
/**
 * Admin Settings Pages Panel Builder.
 *
 * @package    ReportAbuse
 * @subpackage Admin\Panels
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Admin\Panels;

// Exit if the file is accessed directly over web.
use Press_Themes\PT_Settings\Panel;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Panel_Notifications {

	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools';
		$section  = $panel->add_section( 'notification-settings', _x( 'Notification Settings', 'Admin settings section title', 'buddypress-moderation-tools' ), sprintf( _x( 'For more details, please view <a href="%s">pages documentation</a>.', 'admin section description', 'buddypress-moderation-tools' ), $doc_link ) );

		$default_settings = bpmts_get_default_settings();

		$general_fields = array(
			array(
				'name'    => 'bpra_notification_methods',
				'label'   => _x( 'Notifications', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $default_settings['bpra_notification_methods'],
				'options' => array(
					'email' => __( 'Email', 'buddypress-moderation-tools' ),
					'local' => __( 'Local', 'buddypress-moderation-tools' ),
				),
			),
			array(
				'name'    => 'bpra_new_report_notify_entities',
				'label'   => _x( 'New report notification', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $default_settings['bpra_new_report_notify_entities'],
				'options' => array(
					'admin'    => __( 'Admin', 'buddypress-moderation-tools' ),
					'creator'  => __( 'Item creator', 'buddypress-moderation-tools' ),
					'reporter' => __( 'Reporter', 'buddypress-moderation-tools' ),
				),
			),
			array(
				'name'    => 'bpra_item_hide_notify_entities',
				'label'   => _x( 'Item hide notification', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $default_settings['bpra_item_hide_notify_entities'],
				'options' => array(
					'admin'   => __( 'Admin', 'buddypress-moderation-tools' ),
					'creator' => __( 'Item creator', 'buddypress-moderation-tools' ),
				),
			),
			array(
				'name'    => 'bpra_item_delete_notify_entities',
				'label'   => _x( 'Item delete notification', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $default_settings['bpra_item_delete_notify_entities'],
				'options' => array(
					'admin'    => __( 'Admin', 'buddypress-moderation-tools' ),
					'creator'  => __( 'Item creator', 'buddypress-moderation-tools' ),
					'reporter' => __( 'Reporter', 'buddypress-moderation-tools' ),
				),
			),
			array(
				'name'    => 'bpra_item_clear_notify_entities',
				'label'   => _x( 'Item cleaned notification', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $default_settings['bpra_item_clear_notify_entities'],
				'options' => array(
					'admin'    => __( 'Admin', 'buddypress-moderation-tools' ),
					'creator'  => __( 'Item creator', 'buddypress-moderation-tools' ),
					'reporter' => __( 'Reporter', 'buddypress-moderation-tools' ),
				),
			),
		);

		$fields = apply_filters( 'bpmts_notification_settings_fields', $general_fields );

		$section->add_fields( $fields );

		self::add_admin_email_settings( $panel );
		self::add_creator_email_settings( $panel );
		self::add_reporter_email_settings( $panel );

	}
	/**
	 * Email settings for admin
	 *
	 * @param Panel $panel Panel class object.
	 */
	public static function add_admin_email_settings( $panel ) {

		$section = $panel->add_section( 'admin-email-settings', _x( 'Admin Email Settings', 'Admin settings section title', 'buddypress-moderation-tools' ) );
		$defaults = bpmts_get_default_settings();

		$fields = array(
			array(
				'name'    => 'bpra_notify_admin_email',
				'label'   => _x( 'Admin email', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_notify_admin_email'],
			),
			array(
				'name'    => 'bpra_new_report_notify_admin_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'for new report', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_new_report_notify_admin_email_subject'],
			),
			array(
				'name'    => 'bpra_new_report_notify_admin_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'for new report', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_new_report_notify_admin_email_content'],
			),
			array(
				'name'    => 'bpra_item_hide_notify_admin_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets hide', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_hide_notify_admin_email_subject'],
			),
			array(
				'name'    => 'bpra_item_hide_notify_admin_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets hide', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_hide_notify_admin_email_content'],
			),
			array(
				'name'    => 'bpra_item_delete_notify_admin_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets deleted', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_delete_notify_admin_email_subject'],
			),
			array(
				'name'    => 'bpra_item_delete_notify_admin_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets deleted', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_delete_notify_admin_email_content'],
			),
			array(
				'name'    => 'bpra_item_clean_notify_admin_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets cleaned', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_clean_notify_admin_email_subject'],
			),
			array(
				'name'    => 'bpra_item_clean_notify_admin_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets cleaned', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_clean_notify_admin_email_content'],
			),
		);

		$section->add_fields( $fields );
	}


	/**
	 * Email settings for creator
	 *
	 * @param Panel $panel Panel class object.
	 */
	public static function add_creator_email_settings( $panel ) {
		$section = $panel->add_section( 'creator-email-settings', _x( 'Creator Email Settings', 'Admin settings section title', 'buddypress-moderation-tools' ) );
		$defaults = bpmts_get_default_settings();
		$fields = array(
			array(
				'name'    => 'bpra_new_report_notify_creator_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'for new report', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_new_report_notify_creator_email_subject'],
			),
			array(
				'name'    => 'bpra_new_report_notify_creator_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'for new report', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_new_report_notify_creator_email_content'],
			),
			array(
				'name'    => 'bpra_item_hide_notify_creator_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets hide', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_hide_notify_creator_email_subject'],
			),
			array(
				'name'    => 'bpra_item_hide_notify_creator_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets hide', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_hide_notify_creator_email_content'],
			),
			array(
				'name'    => 'bpra_item_delete_notify_creator_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets deleted', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_delete_notify_creator_email_subject'],
			),
			array(
				'name'    => 'bpra_item_delete_notify_creator_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets deleted', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_delete_notify_creator_email_content'],
			),
			array(
				'name'    => 'bpra_item_clean_notify_creator_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets cleaned', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_clean_notify_creator_email_subject'],
			),
			array(
				'name'    => 'bpra_item_clean_notify_creator_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets cleaned', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_clean_notify_creator_email_content'],
			),
		);

		$section->add_fields( $fields );
	}

	/**
	 * Email settings for reporter
	 *
	 * @param Panel $panel Panel class object.
	 */
	public static function add_reporter_email_settings( $panel ) {
		$section = $panel->add_section( 'reporter-email-settings', _x( 'Reporter Email Settings', 'Admin settings section title', 'buddypress-moderation-tools' ) );
		$defaults = bpmts_get_default_settings();

		$fields = array(
			array(
				'name'    => 'bpra_new_report_notify_reporter_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'for new report', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_new_report_notify_reporter_email_subject'],
			),
			array(
				'name'    => 'bpra_new_report_notify_reporter_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'for new report', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_new_report_notify_reporter_email_content'],
			),
			array(
				'name'    => 'bpra_item_delete_notify_reporter_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets deleted', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_delete_notify_reporter_email_subject'],
			),
			array(
				'name'    => 'bpra_item_delete_notify_reporter_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets deleted', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_delete_notify_reporter_email_content'],
			),
			array(
				'name'    => 'bpra_item_clean_notify_reporter_email_subject',
				'label'   => _x( 'Subject', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets cleaned', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'text',
				'default' => $defaults['bpra_item_clean_notify_reporter_email_subject'],
			),
			array(
				'name'    => 'bpra_item_clean_notify_reporter_email_content',
				'label'   => _x( 'Content', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'when item gets cleaned', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'rawtext',
				'default' => $defaults['bpra_item_clean_notify_reporter_email_content'],
			),
		);

		$section->add_fields( $fields );
	}
}

