<?php
/**
 * Plugin Name: BuddyPress Moderation Tools
 * Plugin URI: https://buddydev.com/plugins/buddypress-moderation-tools/
 * Description: Let your users report content on your WordPress/BuddyPress site.
 * Version: 1.2.2
 * Author: BuddyDev
 * Author URI: https://buddydev.com
 */

use PressThemes\ModerationTools\Bootstrap\Autoloader;
use PressThemes\ModerationTools\Bootstrap\Bootstrapper;
use PressThemes\ModerationTools\Handlers\NP_Cache;
use PressThemes\ModerationTools\Reportable_Types\Reportable_Item_Types;
use PressThemes\ModerationTools\Schema\Schema;

// Do not allow direct access over web.
defined( 'ABSPATH' ) || exit;


/**
 * Class BPMTS_Moderation_Tools
 *
 * @property-read string                $path absolute path to the plugin directory.
 * @property-read string                $url absolute url to the plugin directory.
 * @property-read string                $basename plugin base name.
 * @property-read string                $version plugin version.
 * @property-read Reportable_Item_Types $reportable_types registered reportable types
 * @property-read NP_Cache              $cache Non persistent cache.
 */
class BPMTS_Moderation_Tools {

	/**
	 * Plugin Version.
	 *
	 * @var string
	 */
	private $version = '1.2.1';

	/**
	 * Class instance
	 *
	 * @var static
	 */
	private static $instance = null;

	/**
	 * Plugins directory path
	 *
	 * @var string
	 */
	private $path;

	/**
	 * Plugins directory url
	 *
	 * @var string
	 */
	private $url;

	/**
	 * Plugin Basename.
	 *
	 * @var string
	 */
	private $basename;

	/**
	 * All Registered reportables.
	 *
	 * @var Reportable_Item_Types
	 */
	private $reportable_types = null;

	/**
	 * Non Persistent cache.
	 *
	 * @var NP_Cache
	 */
	private $cache = null;

	/**
	 * Protected properties. These properties are inaccessible via magic method.
	 *
	 * @var array
	 */
	private static $protected = array( 'instance' );

	/**
	 * PTReport_Abuse constructor.
	 */
	private function __construct() {
		$this->bootstrap();
		$this->setup();
	}

	/**
	 * Get class instance
	 *
	 * @return BPMTS_Moderation_Tools
	 */
	public static function get_instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Bootstrap the core.
	 */
	private function bootstrap() {
		// Setup general properties.
		$this->path     = plugin_dir_path( __FILE__ );
		$this->url      = plugin_dir_url( __FILE__ );
		$this->basename = plugin_basename( __FILE__ );

		// Load autoloader.
		require_once  $this->path . 'src/bootstrap/class-autoloader.php';

		// Register autoloader.
		spl_autoload_register( new Autoloader( 'PressThemes\\ModerationTools\\', __DIR__ . '/src/' ) );
		register_activation_hook( __FILE__, array( $this, 'on_activation' ) );
		register_deactivation_hook( __FILE__, array( $this, 'on_deactivation' ) );
	}

	/**
	 * Load plugin core files and assets.
	 */
	private function setup() {
		$this->cache = new NP_Cache();

		$this->reportable_types = new Reportable_Item_Types();
		Bootstrapper::boot();
	}

	/**
	 * On activation create table
	 */
	public function on_activation() {

		if ( ! get_option( 'bpmts-settings' ) ) {
			require_once $this->path . 'src/core/bpmts-functions.php';
			update_option( 'bpmts-settings', bpmts_get_default_settings() );
		}

		Schema::create();
	}

	/**
	 * Deactivation.
	 */
	public function on_deactivation() {
		 // delete_option( 'bpmts-settings' );
	}

	/**
	 * Magic method for accessing property as readonly(It's a lie, references can be updated).
	 *
	 * @param string $name property name.
	 *
	 * @return mixed|null
	 */
	public function __get( $name ) {

		if ( ! in_array( $name, self::$protected, true ) && property_exists( $this, $name ) ) {
			return $this->{$name};
		}

		return null;
	}
}

/**
 * Return object of class
 *
 * @return BPMTS_Moderation_Tools
 */
function bpmts_moderation_tools() {
	return BPMTS_Moderation_Tools::get_instance();
}

bpmts_moderation_tools();
