jQuery(document).ready(function ($) {
    var itemID, itemType, context, contextID;
    var $popover, $win;

    var $template = $('#bpmts_form_template');
    if( ! $template.get(0)) {
        return;
    }

    var isLogged = PTReportAbuse.isLogged;

    /**
     * Close popup on 'close' click.
     */
    $(document).on('click', '.bpmts-feedback-form-close-button', function(e){
        e.preventDefault();
        closePopup();
        return false;
    });

    /**
     * Open popup on Button click.
     */
    $(document).on('click', 'a.bpmts-report-button', function () {

        var $el = $(this);
        updateState( $el );
        //destroy any previous instance
        closePopup();

        $el.ggpopover('destroy');
        $popover = $el.ggpopover({  title: PTReportAbuse.formTitle, content: $template.html(), container:'body', html: true, placement: 'auto top'});
        $popover.ggpopover('show');
        $win = $('#' + $popover.attr('aria-describedby') );
        return false;

    });

    // on submit.
    $(document).on('click', '.bpmts-feedback-form-submit-button', function (e) {
        var $this = $(this);
        var $form = $this.parents('form');
        var $subject = $form.find('.bpmts-feedback-form-subject');
        var $message = $form.find('.bpmts-feedback-form-message');

        hideFeedbackStatus();

        // check if not a logged in user and has already reported it.
        if (!isLogged && hasReportedEarlier(itemID, itemType)) {
            updateFeedbackStatus( PTReportAbuse.messages.alreadyReported, false );
            return false;
        }

        if ( PTReportAbuse.required.subject && ( ! $subject.get(0) || $subject.val().length <1 ) ) {
            updateFeedbackStatus( PTReportAbuse.messages.subjectRequired, false );
            return false;
        }


        if ( PTReportAbuse.required.message && ( ! $message.get(0) || $message.val().length <1 ) ) {
            updateFeedbackStatus( PTReportAbuse.messages.messageRequired, false );
            return false;
        }

        var data = $form.serialize() + '&item_id=' + itemID + '&item_type=' + itemType + '&context=' + context + '&context_id=' + contextID;
        $this.attr('disabled', true);

        updateFeedbackStatus( PTReportAbuse.messages.messageReporting, true );

        $.post( ajaxurl, data,
            function (resp) {
                $this.attr('disabled', false);
                updateFeedbackStatus(resp.data.message, resp.success);
                if (resp.success) {
                    saveReportedItemToCookie(itemID, itemType);
                }
            },
            'json'
        );
        return false;
    });


    /**
     * Close popup.
     */
    function closePopup() {
        if( $popover !== undefined ) {
            $popover.ggpopover('destroy');
            $win = null;
        }
    }

    /**
     * Update feedback in the popup.
     *
     * @param message
     * @param type
     */
    function updateFeedbackStatus( message, type ) {

        var $infobox = $win.find('.bpmts-feedback-form-status-message');
        var class_name = type ? 'bpmts-feedback-form-success' : 'bpmts-feedback-form-error';
        if( ! $infobox.hasClass( class_name ) ) {
            $infobox.removeClass('bpmts-feedback-form-success bpmts-feedback-form-error');
            $infobox.addClass( class_name );
        }

        $infobox.html('<span>' + message + '</span>').show();
    }

    /**
     * Update feedback in the popup.
     *
     * @param message
     * @param type
     */
    function hideFeedbackStatus( message, type ) {
        var $infobox = $win.find('.bpmts-feedback-form-status-message');
        $infobox.empty();
    }

    /**
     * Update the state of variables from current clicked anchor.
     *
     * @param $anchor
     * @returns {boolean}
     */
    function updateState( $anchor ) {
        if( ! $anchor.get(0) ) {
            return false;
        }
        //always start with a clean slate.
        resetState();

        itemID = $anchor.data('item-id');
        itemType = $anchor.data('item-type');
        context = $anchor.data('context');
        contextID = $anchor.data('context-id');
        return true;
    }

    /**
     * Reset state.
     */
    function resetState() {
        itemID =  itemType = context = contextID = null;
    }

    /**
     * Has user reported this item.
     *
     * @param {int}     itemId item id.
     * @param {string}  itemType item type.
     *
     * @returns {boolean}
     */
    function hasReportedEarlier(itemId, itemType) {
        var key = itemType +'-' + itemId;
        var reportedItems = getAllReportedItemsFromCookie();

        return $.inArray( key, reportedItems ) !== -1;
    }

    /**
     * Save reported item to cookie.
     *
     * @param {int}     itemId item id.
     * @param {string}  itemType item type.
     */
    function saveReportedItemToCookie( itemId, itemType ) {
        var key = itemType +'-' + itemId;
        var items = getAllReportedItemsFromCookie();
        items.push( key );
        //save to cookie.
        $.cookie('bpmts-reported-items', items.join(','), { expires: 15 })
    }

    /**
     * Get an array of reported items.
     *
     * @returns {string[]}
     */
    function getAllReportedItemsFromCookie() {
        var items = $.cookie('bpmts-reported-items');
        if( items === undefined ) {
            items = '';
        }

        return items.split(',');
    }

});