<?php
/**
 * BuddyPress Moderation Tools:- Activity Message Factory.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Activity
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Activity\Messages;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Message factory.
 */
class Activity_Message_Factory {

	/**
	 * Get the message template/Message Builder.
	 *
	 * @param string $action current action.
	 *
	 * @return null|Activity_Message_Builder
	 */
	public static function build( $action ) {
		$message = null;

		switch ( $action ) {

			case 'admin-reported':
				$subject = bpmts_get_option( 'bp_activity_admin_reported_subject' );
				$content = bpmts_get_option( 'bp_activity_admin_reported_message' );
				$message = new Activity_Message_Builder( $subject, $content );
				break;

			case 'admin-hidden':
				$subject = bpmts_get_option( 'bp_activity_admin_hidden_subject' );
				$content = bpmts_get_option( 'bp_activity_admin_hidden_message' );
				$message = new Activity_Message_Builder( $subject, $content );
				break;

			case 'user-hidden':
				$subject = bpmts_get_option( 'bp_activity_user_hidden_subject' );
				$content = bpmts_get_option( 'bp_activity_user_hidden_message' );
				$message = new Activity_Message_Builder( $subject, $content );
				break;

			case 'user-restored':
				$subject = bpmts_get_option( 'bp_activity_user_restored_subject' );
				$content = bpmts_get_option( 'bp_activity_user_restored_message' );
				$message = new Activity_Message_Builder( $subject, $content );
				break;

			case 'user-deleted':
				$subject = bpmts_get_option( 'bp_activity_user_deleted_subject' );
				$content = bpmts_get_option( 'bp_activity_user_deleted_message' );
				$message = new Activity_Message_Builder( $subject, $content );
				break;
		}

		return $message;
	}
}
