<?php
/**
 * BuddyPress Moderation Tools:- Activity Query filter.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BudyPress\Activity
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Activity\Filters;

use PressThemes\ModerationTools\Filters\Query_Filter;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter Activity Query.
 */
class Activity_Query_Filter extends Query_Filter {

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {

		$this->item_type = 'bp_activity';

		$this->settings = array(
			'auto_hide' => bpmts_get_option( 'bp_activity_auto_hide', 0 ),
			'hide_type' => bpmts_get_option( 'bp_activity_hide_type', array( 'all' ) ),
		);
		// each time prefetch is called, assume a new loop.
		add_filter( 'bp_activity_prefetch_object_data', array( $this, 'prefetch' ) );

		// hide from members list everywhere.
		add_action( 'bp_activity_get_where_conditions', array( $this, 'exclude_in_listing' ) );
	}

	/**
	 * Prefetch and save the comment ids used in current loop.
	 *
	 * @param \BP_Activity_Activity[] $activities activities array.
	 *
	 * @return  \BP_Activity_Activity[] $activities activities array.
	 */
	public function prefetch( $activities ) {
		if ( empty( $activities ) ) {
			return $activities;
		}
		$ids = wp_list_pluck( $activities, 'id' );
		$this->cache_hidden_items( $ids );

		return $activities;
	}

	/**
	 * Exclude activity from query.
	 *
	 * @param array $where_conditions conditions.
	 *
	 * @return array
	 */
	public function exclude_in_listing( $where_conditions ) {
		// do not hide inside the admin or if the user is super admin.
		if ( is_super_admin() || ( is_admin() && ! defined( 'DOING_AJAX' ) ) ) {
			return $where_conditions;
		}

		if ( $this->hide_for_reporters_enabled() ) {
			$where_conditions[] = "a.id NOT IN ({$this->get_sql_for_reported_items( get_current_user_id(), 'bp_activity' )})";
		}

		if ( $this->hide_for_all_enabled() ) {
			$where_conditions[] = "a.id NOT IN ({$this->get_sql_for_hidden_items( 'bp_activity' )})";
		}

		return $where_conditions;
	}
}
