<?php
/**
 * BBPress Forums Reportable support.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage PressThemes\ModerationTools\Reportable_Types\BBPress
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh, Ravi Sharma
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BBPress;

use Press_Themes\PT_Settings\Page;
use PressThemes\ModerationTools\Reportable_Types\BBPress\Forum\Admin\Forum_Settings_Panel;
use PressThemes\ModerationTools\Reportable_Types\BBPress\Forum\Filters\Forum_Query_Filter;
use PressThemes\ModerationTools\Reportable_Types\BBPress\Forum\Handlers\Forum_Action_Handler;
use PressThemes\ModerationTools\Reportable_Types\BBPress\Forum\Handlers\Forum_UI_Helper;
use PressThemes\ModerationTools\Reportable_Types\Reportable_Item_Type;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Reportable_Type_BBP_Forum BuddyPress Forum
 */
class Reportable_Type_BBP_Forum extends Reportable_Item_Type {

	/**
	 * Reportable_Type_BBP_Forum constructor.
	 */
	public function __construct() {
		parent::__construct( 'forum', __( 'bbPress Forum', 'buddypress-moderation-tools' ) );
	}

	/**
	 * Load dependencies if any.
	 */
	public function boot() {
	}

	/**
	 * Setup.
	 */
	public function setup() {
		// do some setup.
		Forum_Query_Filter::boot();
		// Boot action handlers.
		Forum_Action_Handler::boot();
		// Boot UI Helper to add messages/buttons as needed.
		Forum_UI_Helper::boot();
	}

	/**
	 * Add activity admin settings panel.
	 *
	 * @param Page $page page object.
	 */
	public function add_admin_settings( $page ) {
		$panel = $page->add_panel( 'forum', __( 'bbPress Forum', 'buddypress-moderation-tools' ), __( 'BBPress Forum reporting setting', 'buddypress-moderation-tools' ) );

		Forum_Settings_Panel::build( $panel );
	}

	/**
	 * Delete an item of this type.
	 *
	 * @param int $item_id item id.
	 */
	public function delete( $item_id ) {
		bbp_delete_forum( $item_id );
	}

	/**
	 * Check that Forum exists.
	 *
	 * @param int    $item_id post id.
	 * @param string $context ignore.
	 * @param int    $context_id ignore.
	 *
	 * @return bool
	 */
	public function is_valid( $item_id, $context, $context_id ) {
		$forum = bbp_get_forum( $item_id );

		if ( empty( $forum ) ) {
			return false;
		}

		return true;
	}

	/**
	 * Get user threshold.
	 *
	 * @return int
	 */
	public function get_threshold() {
		return bpmts_get_option( 'bbp_forum_threshold', 5 );
	}

	/**
	 * Get the item object.
	 *
	 * @param int $item_id group id.
	 *
	 * @return mixed Null if error or forum (in specified form) if success
	 */
	public function get_item( $item_id ) {
		return bbp_get_forum( $item_id );
	}

	/**
	 * Get the thumbnail
	 *
	 * @param int    $item_id item id.
	 * @param string $size thumb|full.
	 *
	 * @return string
	 */
	public function get_item_thumbnail( $item_id, $size ) {
		return '';
	}

	/**
	 * Get item title.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_title( $item_id ) {
		return '';
	}

	/**
	 * Get item description.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_description( $item_id ) {
		$forum = $this->get_item( $item_id );
		return ! empty( $forum ) ? $forum->post_excerpt : '';
	}

	/**
	 * Get Post Permalink.
	 *
	 * @param int $item_id user id.
	 *
	 * @return false|string
	 */
	public function get_item_permalink( $item_id ) {
		return get_permalink( $item_id );
	}

	/**
	 * Get item edit url.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_edit_url( $item_id ) {
		return get_edit_post_link( $item_id );
	}

	/**
	 * Get item delete url.
	 *
	 * @param int $item_id item id.
	 *
	 * @return string
	 */
	public function get_item_delete_url( $item_id ) {
		return get_delete_post_link( $item_id );
	}
}
