<?php
/**
 * Model class for report log table
 *
 * @package buddypress-moderation-tools
 */

namespace PressThemes\ModerationTools\Models;

use PressThemes\ModerationTools\Schema\Schema;

/**
 * Class Report
 *
 * @property-read int    $id             Row id.
 * @property-read int    $queue_id       queue id.
 * @property-read int    $reporter_id    User id.
 * @property-read int    $is_auto        Is auto generated report by the system.
 * @property-read string $name           User name.
 * @property-read string $email          User email.
 * @property-read string $ip             IP address.
 * @property-read string $subject        Report subject.
 * @property-read string $message        Report content.
 * @property-read int    $category       Report category.
 * @property-read string $created_at     Reported date.
 * @property-read string $updated_at     Report update date.
 */
class Report extends Model {

	/**
	 * Table name.
	 *
	 * @return string
	 */
	public static function table() {
		return Schema::table( 'reports' );
	}

	/**
	 * Table schema.
	 *
	 * @return array
	 */
	public static function schema() {
		return array(
			'id'            => 'integer',
			'queue_id'      => 'integer',
			'log_id'        => 'integer',
			'reporter_id'   => 'integer',
			'is_auto'       => 'integer',
			'name'          => 'string',
			'email'         => 'string',
			'ip'            => 'string',
			'subject'       => 'string',
			'message'       => 'string',
			'category'      => 'integer',
			'created_at'    => 'datetime',
			'updated_at'    => 'datetime',
		);
	}
}
