<?php
/**
 * Admin functions.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Admin
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

// exit on direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 0 );
}

/**
 * Show admin notice if any.
 */
function bpmts_admin_notice() {
	if ( empty( $_GET['message'] ) ) {
		return;
	}
	$type = isset( $_GET['message-type'] ) ? trim( $_GET['message-type'] ) : 'fade';

	?>
    <div class="updated <?php echo esc_attr( $type ); ?>">
        <p>
			<?php echo wp_kses_data( $_GET['message'] ); ?>
        </p>
    </div>
	<?php
}

/**
 * Get url for the queue item pages.
 *
 * @param array $args args.
 *
 * @return string
 */
function bpmts_admin_get_queue_url( $args = array() ) {

	$defaults = array(
		'page' => 'bpmts-moderation',
	);

	$args = wp_parse_args( $args, $defaults );
	if ( empty( $args['bpmts_state'] ) ) {
		unset( $args['bpmts_state'] );
    }
	$args = urlencode_deep( $args );

	return add_query_arg( $args, admin_url( 'admin.php' ) );
}

/**
 * Get url for the queue item pages.
 *
 * @param array $args args.
 *
 * @return string
 */
function bpmts_admin_get_queue_entry_url( $args = array() ) {

	$args = wp_parse_args( $args, array(
		'queue_id' => 0,
	) );

	return bpmts_admin_get_queue_url( $args );
}

/**
 * Get url for the log item pages.
 *
 * @param array $args args.
 *
 * @return string
 */
function bpmts_admin_get_log_url( $args = array() ) {

	$defaults = array(
		'page' => 'bpmts-log',
	);

	$args = wp_parse_args( $args, $defaults );

	return add_query_arg( $args, admin_url( 'admin.php' ) );
}

/**
 * Get url for the queue item pages.
 *
 * @param array $args args.
 *
 * @return string
 */
function bpmts_admin_get_log_entry_url( $args = array() ) {

	$args = wp_parse_args( $args, array(
		'log_id' => 0,
	) );

	return bpmts_admin_get_queue_url( $args );
}

