(function (blocks, i18n, element) {
    var el = element.createElement;
    var __ = i18n.__;

    const matomo_icon = el('img', {src: 'data:image/svg+xml;base64,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'});

    blocks.registerBlockType('matomo/matomo-opt-out', {
        title: __('Matomo opt out', 'matomo'),
        icon: matomo_icon,
        category: 'text',
        example: {},
        edit: function () {
            return __('Matomo opt out', 'matomo');
        },
        save: function () {
            return '[matomo_opt_out]';
        },
    });
})(window.wp.blocks, window.wp.i18n, window.wp.element);