<?php
/**
 * This is the main GeoDirectory Custom Post Types plugin file, here we declare and call the important stuff
 *
 * @package           GeoDir_Custom_Posts
 * @copyright         2016 AyeCode Ltd
 * @license           GPL-2.0+
 * @since             1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:       GeoDirectory Custom Post Types
 * Plugin URI:        https://wpgeodirectory.com/downloads/custom-post-types/
 * Description:       Allows to create and add as many CPT's as you need, allowing you to divide categories and manage features and parameters per CPT.
 * Version:           2.0.0.13
 * Author:            AyeCode Ltd
 * Author URI:        https://wpgeodirectory.com/
 * Requires at least: 4.9
 * Tested up to:      5.2
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       geodir_custom_posts
 * Domain Path:       /languages
 * Update URL:        https://wpgeodirectory.com
 * Update ID:         65108
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

if ( !defined( 'GEODIR_CP_VERSION' ) ) {
	define( 'GEODIR_CP_VERSION', '2.0.0.13' );
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function geodir_load_custom_posts() {
    global $geodir_custom_posts;

	if ( ! defined( 'GEODIR_CP_PLUGIN_FILE' ) ) {
		define( 'GEODIR_CP_PLUGIN_FILE', __FILE__ );
	}

	/**
	 * The core plugin class that is used to define internationalization,
	 * dashboard-specific hooks, and public-facing site hooks.
	 */
	require_once ( plugin_dir_path( GEODIR_CP_PLUGIN_FILE ) . 'includes/class-geodir-cp.php' );

    return $geodir_custom_posts = GeoDir_CP::instance();
}
add_action( 'geodirectory_loaded', 'geodir_load_custom_posts' );
