;(function ($) {

    const app = {
        init: () => {
            $('#update-nav-menu').bind('click', app.handleMenuSwitcher);
            $(document).on('click', ".menu-item-settings .image-choose-wrap label", app.switchSelection);
        },

        switchSelection: function (e) {
            e.preventDefault();
            $(this).siblings().removeClass('active');
            $(this).addClass('active').find('input').prop('checked', true);

        },

        handleMenuSwitcher: function (e) {

            if (-1 != e.target.className.indexOf("item-edit")) {
                $("input[value='#darkmode_switcher'][type=text]").parents(".menu-item-settings").each(function () {
                    const id = $(this).attr("id").substring(19);

                    $(this).children("p:not( .field-move )").remove();

                    const images = [
                        '1.svg',
                        '2.svg',
                        '3.png',
                        '4.svg',
                        '5.svg',
                        '6.svg',
                        '7.svg',
                        '8.svg',
                        '9.png',
                        '10.png',
                        '11.png',
                        '12.png',
                        '13.png',
                        '19.png',
                    ];

                    let html = '';

                    images.map((image, i) => {
                            i = i + 1;

                            i = i == 14 ? 19 : i;

                            let style = wpDarkMode.nav_switches[id];
                            style = style ? style : 3;

                            const checked = style == i;

                            html += (
                                `<label class="${checked ? 'active' : ''}" for="switch_style_${id}_${i}">
                                <input type="radio" ${checked ? 'checked' : ''} id="switch_style_${id}_${i}" name="switch_style[${id}]" value="${i}" />
                                <img src=${wpDarkMode.pluginUrl + 'assets/images/button-presets/' + image} class="image-choose-img"/>
                            </label>`
                            );
                        }
                    );

                    $(this).prepend(`<div class="image-choose-wrap">${html}</div>`);


                    $(this).append($("<input>").attr({
                        type: "hidden",
                        id: "edit-menu-item-title-" + id,
                        name: "menu-item-title[" + id + "]",
                        value: 'Darkmode Switcher'
                    }));

                    $(this).append($("<input>").attr({
                        type: "hidden",
                        id: "edit-menu-item-url-" + id,
                        name: "menu-item-url[" + id + "]",
                        value: "#darkmode_switcher"
                    }));

                    $(this).append($("<input>").attr({
                        type: "hidden",
                        id: "edit-menu-item-wp_dark_mode-detect-" + id,
                        name: "menu-item-wp_dark_mode-detect[" + id + "]",
                        value: 1
                    }));

                });
            }
        }

    };

    $(document).ready(app.init);
})(jQuery);