<?php

/**
 * @link       http://webnus.biz
 * @since      1.0.0
 *
 * @package    Deeper Comments
 */

abstract class Depc_Controller {

	private static $instances = array();
	protected $model;
	protected $user_setting;

	/**
	 * Provides access to a single instance of a module using the singleton pattern
	 *
	 * @since    1.0.0
	 */
	public static function get_instance() {
		$classname = get_called_class();

		if ( ! isset( self::$instances[ $classname ] ) ) {
			self::$instances[ $classname ] = new $classname();
		}
		return self::$instances[ $classname ];

	}

	/**
	 * Get model
	 *
	 * @since    1.0.0
	 */
	protected static function get_model() {

		return static::get_instance()->model;

	}

	/**
	 * Get model
	 *
	 * @since    1.0.0
	 */
	protected function get_user_settings() {

		return Depc_Settings::instance()->get_user_option();
	}

	/**
	 * Render a template
	 *
	 * @since    1.0.0
	 */
	protected static function render_template( $default_template_path = false, $variables = array(), $require = 'once' ){

		if ( ! $template_path = locate_template( basename( $default_template_path ) ) ) {
			$template_path =  Depc_Core::get_depc_path() . '/views/' . $default_template_path;
		}

		if ( is_file( $template_path ) ) {
			extract( $variables );
			ob_start();
			if ( 'always' == $require ) {
				require( $template_path );
			} else {
				require_once( $template_path );
			}
			$template_content = apply_filters( 'depc_template_content', ob_get_clean(), $default_template_path, $template_path, $variables );
		} else {
			$template_content = '';
		}

		return $template_content;
	}

	/**
	 * Clears caches of content generated by caching plugins like WP Super Cache
	 *
	 * @since    1.0.0
	 */
	protected static function clear_caching_plugins() {

		// WP Super Cache
		if ( function_exists( 'wp_cache_clear_cache' ) ) {
			wp_cache_clear_cache();
		}

		// W3 Total Cache
		if ( class_exists( 'W3_Plugin_TotalCacheAdmin' ) ) {
			$w3_total_cache = w3_instance( 'W3_Plugin_TotalCacheAdmin' );
			if ( method_exists( $w3_total_cache, 'flush_all' ) ) {
				$w3_total_cache->flush_all();
			}
		}

	}

	/**
	* Get post id.
	*
	* @since    1.0.0
	*/
	public function post_id() {

		return get_the_ID();

	}

	/**
	 * Constructor
	 *
	 */
	abstract protected function __construct();

	/**
	 * Register callbacks for actions and filters
	 *
	 */
	abstract protected function register_hook_callbacks();

}
