<?php
/**
 * ReportAbuse:- User UI Helper.
 *
 * @package    ReportAbuse
 * @subpackage User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Message\Handlers;

// Exit if files access directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Message_UI_Helper
 *
 * Buttons & Messages management.
 */
class Message_UI_Helper {

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		add_action( 'bp_before_message_thread_list', array( $this, 'show_block_unblock_button' ) );
	}


	/**
	 * Add block/unblock button on single message thread.
	 */
	public function show_block_unblock_button() {

		// only message involving single user can be blocked.
		if ( ! bp_is_my_profile() || bp_get_thread_recipients_count() != 2 ) {
			return;
		}

		global $thread_template;

		if ( ! $thread_template ) {
			return;
		}

		$recipients = wp_list_pluck( $thread_template->thread->recipients, 'user_id' );

		if ( empty( $recipients ) ) {
			return;
		}

		$my_id    = get_current_user_id();
		$other_id = 0;
		foreach ( $recipients as $user_id ) {
			if ( $user_id != $my_id ) {
				$other_id = $user_id;
				break;
			}
		}

		echo $this->get_button( $my_id, $other_id, $thread_template->thread->id );
	}

	/**
	 * Get the button.
	 *
	 * @param int $user_id user id.
	 * @param int $other_id other user id.
	 * @param int $thread_id thread id.
	 *
	 * @return string
	 */
	private function get_button( $user_id, $other_id, $thread_id ) {
		if ( ! bpmts_user_has_reported_item( $user_id, $other_id, 'user' ) ) {
			return $this->get_report_button( $user_id, $other_id, $thread_id );
		} else {
			return $this->get_unblock_button( $user_id, $other_id );
		}
	}

	/**
	 * Report button.
	 *
	 * @param int $user_id reporter id.
	 * @param int $other_id other user id.
	 * @param int $thread_id thread id.
	 *
	 * @return string
	 */
	public function get_report_button( $user_id, $other_id, $thread_id ) {

		if ( bpmts_user_can_report() ) {
			return bpmts_get_report_button( array(
				'item_id'    => $other_id,
				'item_type'  => 'user',
				'context'    => 'bp_message',
				'context_id' => $thread_id,
			) );
		}

		return '';
	}

	public function get_unblock_button( $user_id, $blocked_id ) {

	}
}
