<?php
/**
 * BuddyPress Moderation Tools:- Topic Message Factory.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage BBPress\Topic
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BBPress\Topic\Messages;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Message factory.
 */
class Topic_Message_Factory {

	/**
	 * Get the message template/Message Builder.
	 *
	 * @param string $action current action.
	 *
	 * @return null|Topic_Message_Builder
	 */
	public static function build( $action ) {
		$message = null;

		switch ( $action ) {

			case 'admin-reported':
				$subject = bpmts_get_option( 'bbp_reply_admin_reported_subject' );
				$content = bpmts_get_option( 'bbp_reply_admin_reported_message' );
				$message = new Topic_Message_Builder( $subject, $content );
				break;

			case 'admin-hidden':
				$subject = bpmts_get_option( 'bbp_reply_admin_hidden_subject' );
				$content = bpmts_get_option( 'bbp_reply_admin_hidden_message' );
				$message = new Topic_Message_Builder( $subject, $content );
				break;

			case 'user-hidden':
				$subject = bpmts_get_option( 'bbp_reply_user_hidden_subject' );
				$content = bpmts_get_option( 'bbp_reply_user_hidden_message' );
				$message = new Topic_Message_Builder( $subject, $content );
				break;

			case 'user-restored':
				$subject = bpmts_get_option( 'bbp_reply_user_restored_subject' );
				$content = bpmts_get_option( 'bbp_reply_user_restored_message' );
				$message = new Topic_Message_Builder( $subject, $content );
				break;

			case 'user-deleted':
				$subject = bpmts_get_option( 'bbp_reply_user_deleted_subject' );
				$content = bpmts_get_option( 'bbp_reply_user_deleted_message' );
				$message = new Topic_Message_Builder( $subject, $content );
				break;
		}

		return $message;
	}
}
