<?php
/**
 * Admin Settings Pages Panel Builder.
 *
 * @package    ModerationTools
 * @subpackage Admin\Panels
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Admin\Panels;

// Exit if the file is accessed directly over web.
use Press_Themes\PT_Settings\Panel;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Panel_General {
	/**
	 * Add panel settings.
	 *
	 * @param Panel $panel panel object.
	 */
	public static function build( Panel $panel ) {
		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/moderation-tools-general-settings/';
		$section  = $panel->add_section( 'general-settings', _x( 'General Settings', 'Admin settings section title', 'buddypress-moderation-tools' ), sprintf( _x( 'For more details, please view <a href="%s">documentation</a>.', 'admin section description', 'buddypress-moderation-tools' ), $doc_link ) );

		$defaults = bpmts_get_default_settings();

		$general_fields = array(
			array(
				'name'    => 'reportable_items',
				'label'   => _x( 'Reportable items', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'default' => $defaults['reportable_items'],
				'options' => self::get_reportable_items(),
			),
			array(
				'name'    => 'who_can_report',
				'label'   => _x( 'Who can report', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'type'    => 'select',
				'default' => $defaults['who_can_report'],
				'options' => array(
					'all'       => __( 'Visitors & Site members', 'buddypress-moderation-tools' ),
					'logged' => __( 'Only Site members', 'buddypress-moderation-tools' ),
				),
			),

			array(
				'name'    => 'keep_log',
				'label'   => _x( 'Keep Moderation log', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'If enable log will maintain after moderation on items', 'Admin settings field desc', 'buddypress-moderation-tools' ),
				'type'    => 'checkbox',
				'default' => $defaults['keep_log'],
			),

			array(
				'name'    => 'form_fields',
				'label'   => _x( 'Form Fields to show', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'These will be shown on the report abuse/moderation form.', 'Admin settings field desc', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'options' => bpmts_get_registered_form_fields(),
				'default' => $defaults['form_fields'],
			),

			array(
				'name'    => 'required_form_fields',
				'label'   => _x( 'Required fields', 'Admin settings field label', 'buddypress-moderation-tools' ),
				'desc'    => _x( 'User will need to enter values for the required fields.', 'Admin settings field desc', 'buddypress-moderation-tools' ),
				'type'    => 'multicheck',
				'options' => bpmts_get_registered_form_fields(),
				'default' => $defaults['required_form_fields'],
			),
		);

		$fields = apply_filters( 'bpmts_general_settings_fields', $general_fields );

		$section->add_fields( $fields );

	}

	/**
	 * Reportable items
	 *
	 * @return array
	 */
	private static function get_reportable_items() {
		$reportables = bpmts_moderation_tools()->reportable_types->get_all();

		// I wish I could use 'wp_list_pluck' but that will not preserve the key if we have to use field as key.
		$list = array();
		foreach ( $reportables as $reportable ) {
			$list[ $reportable->type ] = $reportable->label;
		}

		return $list;
	}

}

