# Contributing to WPPedia

Looking to contribute something to WPPedia? **Here's how!**


## Reporting issues

We only accept issues that are bug reports or feature requests. Bugs must be
isolated and reproducible problems that can be fixed within WPPedia.
Please read the following guidelines before opening any issue.

1. [**Read the documentation**](#) *available soon*

2. **Does your issue already exist?** Before reporting an issue please check if someone 
else has reported it.

3. **Whenever possible include an example on how to reproduce.** Bugs that can't be reproduced
can't be fixed. When reporting a bug please write down the exact steps you've been gone through
before the bug happened.

4. **Share as much information as possible.** Include operating system and
version, browser and version and of course the plugin Version.

## Pull requests

1. Changes to the JavaScript and CSS parts of the application must be done in the `source/` folder.
Also when pushing remember to don't push the compiled assets.

2. Try not to pollute your pull request with unintended changes. Keep them simple
and small

3. Try to share which browsers your code has been tested in before submitting a
pull request
