<?php
/**
 * Plugin Name: Web3 - Crypto wallet Login & NFT token gating
 * Plugin URI: http://miniorange.com
 * Description: WordPress WEB3 authentication allows the functionality to auto login, auto register into WordPress using the WEB3 Crypto wallet like metamask.
 * Version: 2.4.0
 * Author: miniOrange
 * License: MIT/Expat
 * License URI: https://docs.miniorange.com/mit-license
 */

require '_autoload.php';
use MoWeb3\Base\MoWeb3BaseStructure;
use MoWeb3\Base\MoWeb3InstanceHelper;
use MoWeb3\controller\MoWeb3FlowHandler;
use MoWeb3\view\ButtonView\MoWeb3View;

global $mo_web3_util;

$instance_helper 			       = new MoWeb3InstanceHelper();
$base            			       = new MoWeb3BaseStructure();
$web3_flow                   	   = new MoWeb3FlowHandler();
$web3_button_view                  = new MoWeb3View();


$mo_web3_util        	           = $instance_helper->get_utils_instance();
$settings        			       = $instance_helper->get_settings_instance();
$config_settings_all_methods       = $instance_helper->get_all_method_instances();


mo_web3_load_all_methods( $config_settings_all_methods );




function mo_web3_deactivate() {
	global $mo_web3_util;
	// delete all stored key-value pairs.
	do_action( 'mo_web3_clear_plug_cache' );
	$mo_web3_util->deactivate_plugin();
}

function mo_web3_activate( $plugin){

	global $mo_web3_util;
	$existing_plugin_version = $mo_web3_util->mo_web3_get_option('mo_web3_plugin_version');
	$current_plugin_version = \mo_web3_get_version_number();
	if( false == $existing_plugin_version){
		$mo_web3_util->mo_web3_update_option('mo_web3_plugin_version',$current_plugin_version);
	}
	
}


function moweb3_activation_redirect( $plugin ) {
   
    if( $plugin == plugin_basename( __FILE__ ) ) {
        exit( wp_safe_redirect( admin_url('admin.php?page=mo_web3_settings') ) );
    }
}


add_action( 'activated_plugin', 'moweb3_activation_redirect' );

register_activation_hook( __FILE__, 'mo_web3_activate' );

register_deactivation_hook( __FILE__, 'mo_web3_deactivate' );






?>
