<?php
/**
 * Core
 *
 * Create MoWeb3 Method view Handler.
 *
 * @category   Common, Core
 * @package    MoWeb3\MoWeb3MethodViewHandler
 * @author     miniOrange <info@xecurify.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link       https://miniorange.com
 */

namespace MoWeb3\view\ShortcodeInfoView;

/**
 * Class to Create MoWeb3 Method View Handler.
 *
 * @category Common, Core
 * @package  MoWeb3\MoWeb3MethodViewHandler\CreateMoWeb3View
 * @author   miniOrange <info@xecurify.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link     https://miniorange.com
 */

class MoWeb3ShortcodeInfo {

    public $util;
    public $button_view;


    public function __construct() {
        
		$this->util   =new \MoWeb3\MoWeb3Utils;
        $this->button_view  =   new \MoWeb3\view\ButtonView\MoWeb3View;
        $this->button_view->mo_web3_wp_enqueue();
        
    }

    public function view(){
        ?>


            <div  class="mo_support_layout container prem-info"  id="web3Shortcode" style="font-size:0.9rem"><?php 
            $this->util->render_premium_info_ui('The Shortcode for Login Button is available in standard and higher plans. ');
            ?><div class="row">
                    <div class="col-11">
                        <h1>Sign in options</h1><br>
               
                    </div>
                </div>
				

                <div class="row">

                    <div class="col-11">
                        <strong >
                        Option 1: Use a Login button on WordPress default Login Form for different providers login method.</strong>
                        <ol>
                            <li>Go to Configure Settings tab.</li>
                            <li>Check <b>"Enable Web3 user Login"</b>.</li>
                        </ol>
                        <strong>Option 2: Use a Shortcode</strong>
                        <ol style="list-style:none">
                            
                            <li>Place shortcode <b>[mo_web3_login_button_shortcode <i>redirection_url</i>="https://example.com" <i>text_color</i>="black"]</b> to add Web3 Login button on WordPress pages.<br><br>
                                <ol style="list-style:disc" >
                                    <li><b>redirection_url</b>,will direct the user on the given url</li>
                                    <li>After login through the web3 login button, button will replaced by the wallet address <b>text_color</b> defines the color of the wallet address</li>
                                </ol>
                            </li>
                        </ol>
                    </div>
                    
                </div>

            </div>

    </br>
            <div class="mo_support_layout container prem-info" style="font-size:0.9rem"><?php 
                $this->util->render_premium_info_ui('The Shortcode to gate specific section of page for crypto wallet users is available in standard and higher plans. ');
                ?>
                <div class="row">
                        <div class="col-11">
                            <h1>Post Restriction</h1><br>
                        </div>                                        
                </div>

                <div class="row">

                        <div class="col-11">
                            <strong>Shortcode Use: </strong><span>Place your content between the shortcode.</span><br>
                            <ol style="list-style:none">
                        

                                <b>[mo_web3_post_restriction_shortcode]</b>
                                <p style="margin:3px;margin-left:30px;" >&lt; Post content that you want to hide &gt;</p>
                                <b>[/mo_web3_post_restriction_shortcode]</b>
                                
                            </ol>
                        </div>

                    </div>
                    
                </div>
                
            </div>

    </br>

            <div class="mo_support_layout container prem-info" style="font-size:0.9rem"><?php 
                $this->util->render_premium_info_ui('The Shortcode to display NFT hold by crypto wallet users is available in enterprise and higher plans. ');
                ?>
                <div class="row">
                        <div class="col-11">
                            <h1>Display NFT hold by User</h1><br>
                        </div>                                        
                </div>

                <div class="row">

                        <div class="col-11">
                            <p style="font-size:14px;"> <strong>Shortcode Use: </strong> Place shortcode <b>[mo_web3_show_nft_shortcode]</b> to show all NFT's hold by user from the configured NFT's settings.</p>
                        </div>

                    </div>
                    
                </div>
                
            </div>

        <?php
    }
}
?>