<?php
/**
 * Core
 *
 * Create MoWeb3 Method view Handler.
 *
 * @category   Common, Core
 * @package    MoWeb3\MoWeb3MethodViewHandler
 * @author     miniOrange <info@xecurify.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link       https://miniorange.com
 */

namespace MoWeb3\view\ButtonView;

/**
 * Class to Create MoWeb3 Method View Handler.
 *
 * @category Common, Core
 * @package  MoWeb3\MoWeb3MethodViewHandler\CreateMoWeb3View
 * @author   miniOrange <info@xecurify.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @link     https://miniorange.com
 */

class MoWeb3View {
    
    /**
     * Constructor
     */
    

    public $util;
   
    public function __construct() {
        
		$this->util   =new \MoWeb3\MoWeb3Utils;

        $is_testing=0;
        add_action( 'login_form', function() use ($is_testing) { 
            $this->mo_web3_add_login_button($is_testing); } );
        
    }

    
  


    public function mo_web3_wp_enqueue()
    {
        wp_enqueue_script( 'mo_web3_bootstrap_min_js', MOWEB3_URL . '/classes/common/Web3/resources/js/bootstrap/bootstrap.js', array(), $ver ="2.3.6", $in_footer = false );
        wp_enqueue_script( 'mo_web3_nft', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/web3_nft.js', array(), $ver = "2.3.6", $in_footer = false );
        wp_enqueue_script( 'mo_web3_wallet_link', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/wallet-sdk-bundle-walletlink.js', array(), $ver ="2.3.6", $in_footer = false );
        wp_enqueue_script( 'mo_web3_walletconnect', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/web3_walletconnect.min.js', array(), $ver = "2.3.7", $in_footer = false );
        wp_enqueue_script( 'mo_web3_web3Min', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/web3Min.js', array(), $ver = "2.3.6", $in_footer = false );
        wp_enqueue_script( 'mo_web3_web3ModalDistIndex', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/web3ModalDistIndex.js', array(), $ver = "2.3.6", $in_footer = false );
        wp_enqueue_script( 'mo_web3_web3_login', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/web3_login.js', array(), $ver = "2.3.6", $in_footer = false );
        wp_enqueue_script( 'mo_web3_web3_modal', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/web3_modal.js', array(), $ver = "2.3.6", $in_footer = false );
        wp_enqueue_script( 'mo_web3_myalgo', MOWEB3_URL . '/classes/common/Web3/resources/js/web3/myalgo.min.js', array(), $ver = "2.3.7", $in_footer = false );
         
        $data = array(
        'ajax_url' => admin_url( 'admin-ajax.php'),
        'wp_nonce'    => wp_create_nonce( 'mo_web3_wp_nonce')
        );
        
        // Localize the script
        wp_localize_script( 'mo_web3_web3_login', 'mo_web3_utility_object', $data );

        wp_enqueue_style( 'mo_web3_style', MOWEB3_URL . '/classes/common/Web3/resources/css/bootstrap/bootstrap.min.css', array(), $ver = "2.3.6", $in_footer = false );
        wp_enqueue_style( 'mo_web3_custom_style', MOWEB3_URL . '/classes/common/Web3/resources/css/styles.css', array(), $ver = \MoWeb3Constants::STYLES_CSS_VERSION, $in_footer = false );
        wp_enqueue_style( 'mo_web3_licensing_plan_view_page_style', MOWEB3_URL . '/classes/common/Web3/resources/css/mo-web3-licensing.css', array(), $ver = "1.0.4", $in_footer = false );

    }


    public function get_button_custom_text(){

        $value = $this->util->mo_web3_get_option("mo_web3_button_custom_text");

        if($value){
            return $value;
        }else{
            $this->util->mo_web3_update_option("mo_web3_button_custom_text","Login with Cryptowallet");
            $this->get_button_custom_text();
        }

    }


  

    public function mo_web3_add_login_button($is_testing=0){
       
     
       $this->mo_web3_wp_enqueue();

       global $mo_web3_util;

       $multiple_crypto_wallet = $mo_web3_util->get_multiple_crypto_wallet();



        $allButtons =$this->util->mo_web3_get_option('mo_web3_display_multiple_button');

        $display_button = true;

        if($allButtons){
            $numOfBtnDisabled =0;
            foreach($allButtons as $key => $value){
               
                if($allButtons[$key]==""){// checking that the button is diabled
                    $numOfBtnDisabled++;
                }
            }
            if($numOfBtnDisabled==sizeof($allButtons)){// true , when all buttons are disabled
                $display_button = false;
            }
        }

        if($display_button){
        ?>

        <div>
            &nbsp;&nbsp;<button onclick="clearMessage();" class="btn btn-outline-primary mb-3" data-toggle="modal" data-target="#multipleCryptowalletModal"  type="button" id="buttonText"  >
                <?php if($is_testing){
                    echo "Test Web3 Connectivity";
                }else{
                    echo esc_attr($this->get_button_custom_text());
                } ?></button>
        </div>
        <?php }?>
        <!-- Modal -->
        <div  class="modal fade"  style="opacity:100%" id="multipleCryptowalletModal" role="dialog" aria-labelledby="multipleCryptowalletModalTitle" aria-hidden="true">
            <div style="z-index:1000" class="modal-dialog modal-dialog-centered" style="max-width:600px;" role="document">
                <div class="modal-content">

                    <div class="modal-header">
                        <div>
                            <h5 class="modal-title" id="exampleModalLongTitle">Connect to your favourite CryptoWallet</h5>
                            <div id="moweb3CustomErrorMessage"></div>
                        </div>
                    </div>

                    <div class="modal-body m-0 p-0" >

                    <?php

                    $allButtons =$this->util->mo_web3_get_option('mo_web3_display_multiple_button');
 
                    if($allButtons==false){?>
                        <div class="hover" onclick="userLoginOut(<?php echo esc_attr($is_testing) ?>);" style="min-height:140px;">

                            <div class="mb-3 pt-2 center">
                                
                                <img class="mr-3" width="30" height="30" src="<?php echo esc_attr(MOWEB3_URL)."/classes/common/Web3/resources/images/cryptowallet_images/metamask.png"; ?>"/>&nbsp;&nbsp;&nbsp;
                                <img class="mr-3" width="30" height="30" src="<?php echo esc_attr(MOWEB3_URL)."/classes/common/Web3/resources/images/cryptowallet_images/coinbase.png"; ?>"/>&nbsp;&nbsp;&nbsp;
                                <img class="mr-3" width="30" height="30" src="<?php echo esc_attr(MOWEB3_URL)."/classes/common/Web3/resources/images/cryptowallet_images/walletconnect.png"; ?>"/>

                            </div>

                            <div class="mb-1 center">
                                <h5>MetaMask, Coinbase, Wallet Connect</h5>
                            </div>

                            <div style="color:#B2B2B2" class="center">
                                <p style="font-size:1rem;">Connect to your MetaMask, Coinbase, Wallet Connect</p>
                            </div>

                        </div>

                    <?php }
                    else{
                        
                    foreach($multiple_crypto_wallet as $key => $value){

                        $name     = $value["id"];
                        $function = $is_testing?$value["testing_function"]:$value["function"];
                        $id       = $name;
                        if($allButtons && isset($allButtons[$name]) && $allButtons[$name]=="checked"){

                            ?>
                            
                                <?php if($name="moweb3Perawallet"){ ?>
                                    <div onclick="<?php echo esc_attr($function); ?>" id="<?php echo esc_attr($id); ?>" class="hover" style="min-height:140px;">

                                        <div class="mb-3 pt-2 center">
                                            <?php 
                                            $wallet_images = $value["logo"];
                                            for($i=0;$i<sizeof($wallet_images);$i++){?>
                                                <img width="30" height="30" src="<?php echo esc_attr(MOWEB3_URL)."/classes/common/Web3/resources/images/cryptowallet_images/".esc_attr($wallet_images[$i]); ?>"/>&nbsp;&nbsp;&nbsp;
                                            <?php }?>
                                        </div>

                                        <div class="mb-1 center">
                                            <h5><?php echo esc_attr($value["data"]);?></h5>
                                        </div>

                                        <div style="color:#B2B2B2" class="center">
                                            <p style="font-size:1rem;">Connect to your <?php echo esc_attr($value["data"]);?></p>
                                        </div>

                                    </div>
                                    <hr>
                                <?php }
                            }
                         
                        }
                    }?>
                </div>
            </div>
        </div>       
     </div>
    <?php
    }
}
?>