// jQuery debounce
!function(t,n){let o,u=t.jQuery||t.Cowboy||(t.Cowboy={});u.throttle=o=function(t,o,e,i){let r,a=0;function c(){let u=this,c=+new Date-a,f=arguments;function d(){a=+new Date,e.apply(u,f)}i&&!r&&d(),r&&clearTimeout(r),i===n&&c>t?d():!0!==o&&(r=setTimeout(i?function(){r=n}:d,i===n?t-c:t))}return"boolean"!=typeof o&&(i=e,e=o,o=n),u.guid&&(c.guid=e.guid=e.guid||u.guid++),c},u.debounce=function(t,u,e){return e===n?o(t,u,!1):o(t,e,!1!==u)}}(this);

class EodDebug{
    constructor(p){
        this.time = {start: window.performance.now()};
        this.periods = {'news':{}, 'fundamental':{}, 'stock':{}};
        // Ping to the current site
        this.ping = 0;
        jQuery.ajax({
            method: "GET",
            url: eod_ajax_url,
            data: {'action': 'eod_ping', 'nonce_code': eod_ajax_nonce}
        }).always(() => {this.ping = window.performance.now() - this.time.start})
    }
    addTimePoint(point_name, period = false){
        let time_point = window.performance.now();
        this.time[point_name] = time_point;
        if(period) {
            if(!this.periods[period.type][period.slug]) this.periods[period.type][period.slug] = {};
            this.periods[period.type][period.slug][period.moment] = time_point;
        }
    }
    showTimeLine(){
        console.log('ping', this.ping);
        let timeline = [];
        for (let point in this.time)
            timeline.push([point, this.time[point]]);

        timeline.sort(function(a, b) {
            return a[1] - b[1];
        });
        for (let point of timeline)
            console.log(point[1].toFixed(2) + ': ' + point[0]);
    }
    showKeyTimePeriods(){
        if(this.ping)
            console.log('AJAX ping: ' + this.ping.toFixed(0) + 'ms');
        if(this.time['DOM content loaded'])
            console.log('DOM loading: ' + this.toSec(this.time['DOM content loaded']));
        // WebSocket
        for(let ws_type of ['cc', 'us', 'forex'])
            if(this.time['WS connection ('+ws_type+') is opened'])
                console.log('WS connecting ('+ws_type+'): ' + this.toSec(this.time['WS connection ('+ws_type+') is opened'] - this.time['DOM content loaded']));
        // Widgets
        for(let type of ['news', 'fundamental', 'stock']) {
            for (let item of Object.values(this.periods[type])) {
                if (item.start && item.end) {
                    let time = item.end - item.start;
                    console.log('receiving '+type+' data: ' + this.toSec(time) +
                        ' (client <' + this.toSec(this.ping) + '> site <' + this.toSec(time - this.ping) + '> API)');
                    break;
                }
            }
        }
    }
    toSec(float){
        return (float/1000).toFixed(2) + 's.';
    }
}
window.eod_debug = new EodDebug;

let ws_eod, ws_eod_queue = {}, ws_eod_data = {};
document.addEventListener('DOMContentLoaded', () => {
    eod_debug.addTimePoint('DOM content loaded');
    eod_init();
});

async function eod_init(){
    eod_display_all_live_tickers();
    eod_display_fundamental_data();
    eod_display_all_historical_tickers();
    // Display items only by AJAX
    if( eod_display_settings.news_ajax ) {
        eod_display_news();
    }

    // Add websockets
    let eod_api_token = await jQuery.ajax({
        method: "POST",
        url: eod_ajax_url,
        data: {
            'action': 'get_eod_token',
            'nonce_code': eod_ajax_nonce,
        }
    });
    ws_eod = {
        'cc': new WebSocket('wss://ws.eodhistoricaldata.com/ws/crypto?api_token=' + eod_api_token),
        'forex': new WebSocket('wss://ws.eodhistoricaldata.com/ws/forex?api_token=' + eod_api_token),
        'us': new WebSocket('wss://ws.eodhistoricaldata.com/ws/us_?apitoken=' + eod_api_token)
    };
    // Define types
    for(let type in ws_eod){
        ws_eod_queue[type] = [];
        ws_eod_data[type] = {};

        // Add main event listeners
        // After connecting, execute the accumulated queue.
        ws_eod[type].addEventListener('open', function(){
            eod_debug.addTimePoint('WS connection ('+type+') is opened');
            while( ws_eod_queue[type].length ){
                ws_eod[type].send( ws_eod_queue[type].shift() );
            }
        });
        // Get response from websocket and call saved listeners
        ws_eod[type].addEventListener('message', function(event){
            let res = JSON.parse(event.data);
            if(!res.s) return;
            call_ws_eod_listeners(type, res);
        });
    }

    // Display widgets
    eod_init_realtime_tickers()
    eod_display_converters();

    // Refresh tickers every minute. It will affect your daily API Limit!
    const EOD_refresh_common_tickers = false,
        EOD_refresh_interval = 60000;             // 60000 = 1 minute
    if(EOD_refresh_common_tickers){
        setInterval(function () {
            console.log("EOD_refresh_common_tickers");
            eod_display_all_live_tickers();
        }, EOD_refresh_interval);
    }
}

/* =========================================
             handle functions
   ========================================= */
/**
 * Replaces zeros with letters
 * @param value - number
 * @returns {number|string|*}
 */
function abbreviateNumber(value) {
    // Check type
    let newValue;
    if(typeof value === 'string'){
        newValue = +value;
    }else{
        newValue = value;
    }

    if(isNaN(newValue) || typeof newValue !== 'number')
        return value;

    if (value >= 1000 || value <= -1000) {
        let shift = 1,
            suffixes = ["", "K", "M", "B", "T"],
            suffixNum = Math.floor( ((""+Math.floor(value)).length - shift)/3 ),
            shortValue = suffixNum !== 0 ? (value / Math.pow(1000,suffixNum)) : value;

        if (shortValue % 1 !== 0)  shortValue = shortValue.toFixed(2);
        newValue = shortValue+suffixes[suffixNum];
    }
    return newValue;
}

/**
 * Add target in websocket
 * @param type - websocket type
 * @param target - symbol of target
 */
function add_ws_eod_target(type, target){
    let message = '{"action": "subscribe", "symbols": "' + target.toUpperCase() + '"}';
    if( ws_eod[type].readyState ) ws_eod[type].send( message );
    else ws_eod_queue[type].push( message );
}

/**
 * Remove target from websocket
 * @param type - websocket type
 * @param target - symbol of target
 */
function remove_ws_eod_target(type, target){
    let message = '{"action": "unsubscribe", "symbols": "' + target.toUpperCase() + '"}';
    if( ws_eod[type].readyState ) ws_eod[type].send( message );
    else ws_eod_queue[type].push( message );
}

/**
 * Init websocket listeners.
 *
 * ws_eod_data contains data about all used targets.
 * Each item contains listeners that ran when new data is received on the websocket.
 * This is necessary so that different widgets and interfaces can react differently to receiving the same data.
 *
 * @param type - websocket type
 * @param res - websocket response
 */
function call_ws_eod_listeners(type, res){
    res.type = type;
    let listeners = ws_eod_data[type][res.s].listeners;
    for(let l_name in listeners){
        listeners[ l_name ](res);
    }
}

/**
 * Check if the target exists in the ws_eod_data
 * @param type - websocket type
 * @param target - symbol of target
 * @param only_return - if not exist create item
 * @returns {boolean|*} -
 */
function check_ws_eod_data_item(type, target, only_return = false){
    type = type.toLowerCase();
    if( !ws_eod_data[type] ) return false;

    let is_exist = (target.toUpperCase() in ws_eod_data[type]);
    if(only_return) return is_exist;

    // Target not found
    if( !is_exist ) {
        ws_eod_data[type][ target.toUpperCase() ] = {
            listeners: {}
        }

        // Add target in websocket
        add_ws_eod_target(type, target);
    }

    return ws_eod_data[type][ target.toUpperCase() ];
}

/**
 * Remove data from ws_eod_data and close ws messages for specified target
 * @param type - websocket type
 * @param target - symbol of target
 * @param listener_name - the name of the widget for which the listener is created
 * @returns {boolean|*} -
 */
function remove_ws_eod_data_item(type, target, listener_name){
    type = type.toLowerCase();
    if( !ws_eod_data[type] ) return false;

    let is_exist = (target.toUpperCase() in ws_eod_data[type]);

    if(is_exist){
        // Remove the listener. If there are none left, then delete the target itself.
        let listeners = ws_eod_data[type][ target.toUpperCase() ].listeners;
        delete listeners[ listener_name ];

        if(Object.keys(listeners).length === 0) remove_ws_eod_target(type, target);
    }

    return ws_eod_data[type][ target.toUpperCase() ];
}

/**
 * Get EOD fundamental data
 * @param target - symbol of target
 * @param callback - callback function
 * @returns {boolean|*} -
 */
function get_eod_fundamental(target, callback){
    if(typeof callback !== 'function' || !target) return false;

    jQuery.ajax({
        dataType: "json",
        method: "POST",
        url: eod_ajax_url,
        data: {
            'action': 'get_fundamental_data',
            'nonce_code': eod_ajax_nonce,
            'target': target
        }
    }).always((data) => {
        if(data.error) console.log('EOD-error: ' +data.error, target);
        callback(data);
    });
}

/**
 * Get EOD ticker data
 * @param type - ticker type (live, realtime, historical)
 * @param list - list of symbols
 * @param callback - callback function
 * @returns {boolean|*} -
 */
function get_eod_ticker(type = 'historical', list, callback){
    if(typeof callback !== 'function' || !jQuery.isArray(list) || list.length < 1) return false;
    // Log
    let debug_slug = list.join(',');
    eod_debug.addTimePoint('AJAX request to the realtime stock API for ('+debug_slug+')',{
        type: 'stock',
        slug: debug_slug,
        moment: 'start'
    });

    jQuery.ajax({
        dataType: "json",
        method: "POST",
        url: eod_ajax_url,
        data: {
            'action': 'get_real_time_ticker',
            'nonce_code': eod_ajax_nonce,
            'list': list,
            'type': type
        }
    }).always((data) => {
        if(data.error) console.log('EOD-error: ' +data.error, type, list);
        // Log
        eod_debug.addTimePoint('AJAX response from the realtime stock API for ('+debug_slug+'), render items',{
            type: 'stock',
            slug: debug_slug,
            moment: 'end'
        });
    })
    .done((data) => { callback(data); });
}


/* =========================================
     loading and displaying all financial news
   ========================================= */
/**
 * Initiate the loading and display financial news on the page.
 * @param $items jQuery list of EOD news boxes. Default displaying all .eod_news_list elements on page.
 */
function eod_display_news( $items = false ){
    if($items && !($items instanceof jQuery)) return;
    if(!$items) $items = jQuery(".eod_news_list");

    $items.each(function(){
        eod_display_news_item( jQuery(this) );
    });
}

/**
 * Loading and display financial news for the current item
 * @param $box
 */
function eod_display_news_item( $box ){
    if(!($box instanceof jQuery)) return;
    $box = $box.eq(0);

    // Loading animation
    $box.addClass('eod_loading');

    // Collect parameters
    let props = {};
    for(let prop of ['target','tag','from','to','limit','pagination']) {
        let val = $box.attr('data-' + prop);
        if(val) props[prop] = val;
    }
    if(!props.target && !props.tag) return false;

    // Log
    eod_debug.addTimePoint('AJAX request to the news API for ('+props.target+')',{
        type: 'news',
        slug: props.target,
        moment: 'start'
    });

    // Get and display news html
    jQuery.ajax({
        dataType: "json",
        method: "POST",
        url: eod_ajax_url,
        data: {
            'action': 'get_eod_financial_news',
            'nonce_code': eod_ajax_nonce,
            'props': props
        }

    }).always((data) => {
        $box.data('target', props.target).removeClass('eod_loading');
        if(!data) console.log('EOD-error: empty news response', props);

    }).done((data) => {
        if(!data || data.error) return false;
        // Log
        eod_debug.addTimePoint('AJAX response from the news API for ('+props.target+'), render item',{
            type: 'news',
            slug: props.target,
            moment: 'end'
        });

        // Sort by date
        data.sort(function(a,b){
            return new Date(b.date) - new Date(a.date);
        });
        // Discard the excess and duplicates
        let whitelist = [], res = [];
        for(let i=0; i<data.length; i++){
            let slug = data[i].date + data[i].title;
            if( whitelist.indexOf(slug) === -1 ){
                res.push(data[i]);
                whitelist.push(slug);
            }
        }
        if(props.limit) res = res.slice(0, parseInt(props.limit));

        // Render
        eod_render_news_item($box, res);
    });
}
function eod_render_news_item( $box, data ){
    // Save data
    $box.data('data', data);

    // Remove old list and pagination
    $box.find('.list, .eod_pagination').remove();

    // Add pagination
    let pagination = $box.attr('data-pagination'),
        limit = pagination ? Math.abs(pagination) : data.length,
        last_page = Math.ceil(data.length/limit);
    if(pagination) {
        let $pagination = jQuery('\
                <div class="eod_pagination start">\
                    <button class="prev"></button>\
                    <span>Page</span>\
                    <input type="number" min="1" value="1" max="' + last_page + '">\
                    <span>of ' + last_page + '</span>\
                    <button class="next"></button>\
                </div>');

        // Change page event
        $pagination.find('input[type=number]').on('change', function () {
            let $input = jQuery(this),
                $box = $input.closest('.eod_news_list');

            // Check range
            if (parseInt($input.val()) < 1)
                $input.val(1);
            if (parseInt($input.val()) > parseInt($input.attr('max')))
                $input.val($input.attr('max'));

            // Check last and fist page
            $pagination.toggleClass('start', parseInt($input.val()) === 1);
            $pagination.toggleClass('end', $input.val() === $input.attr('max'));

            // Change news list
            eod_set_news_page($box, parseInt($input.val()));
        });

        // Click on arrow button
        $pagination.find('button').on('click', function () {
            let $input = jQuery(this).siblings('input').eq(0),
                d = jQuery(this).hasClass('next') ? 1 : -1,
                current_page = parseInt($input.val()),
                max_page = $input.attr('max'),
                next_page = current_page + d;

            if (next_page < 1 || next_page > max_page) return false;

            $input.val(next_page).change();
        });

        $box.prepend($pagination);
    }
    // Add news list container
    $box.prepend( jQuery('<div class="list"></div>') )

    eod_set_news_page($box);
}
function eod_set_news_page( $box, page = 1 ){
    let data = $box.data('data');
    if(!data) return;

    let news = [],
        limit = $box.attr('data-pagination') ? parseInt($box.attr('data-pagination')) : data.length,
        offset = (page-1)*limit;
    for(let i=0; i<limit && (offset+i)<data.length; i++)
        news.push( eod_news_item_html( data[offset+i] ) );

    if(news.length > 0) {
        $box.find('.list').html(news);
    }else{
        $box.html('<div class="eod_error">News not found</div>');
    }
}
function eod_news_item_html( item ){
    // Tags
    let tags = '';
    for(let tag of item.tags)
        tags += '<li>'+tag+'</li>';

    // Datetime
    let display_date, number,
        timestamp = new Date( item.date ).getTime(),
        now = new Date().getTime(),
        time_ago = (now - timestamp)/1000;
    if(time_ago > 24*3600){
        let date_options = {year: 'numeric', month: 'long', day: 'numeric', hour: 'numeric', minute: 'numeric'};
        display_date = new Date(timestamp).toLocaleDateString("en-US", date_options);
    }else{
        if(time_ago > 3600){
            number = Math.floor(time_ago/3600);
            display_date = number + ( number>1 ? ' hours ago' : ' hour ago');
        }else{
            number = Math.floor(time_ago/60);
            display_date = number + ( number>1 ? ' minutes ago' : ' minute ago');
        }
    }

    return '\
        <div class="eod_news_item">\
            <div class="thumbnail"></div>\
            <a rel="nofollow" target="_blank" class="h" href="'+item.link+'">'+item.title+'</a>\
            <time dateTime="'+item.date+'" class="date">'+display_date+'</time>\
            <blockquote cite="'+item.link+'">\
                <div class="description">\
                    '+ item.content.substring(0, 300) +'\
                </div>\
            </blockquote>\
            <ul class="tags">'+tags+'</ul>\
        </div>';
}

/* =========================================
     loading and displaying all tickers
   ========================================= */
// Render function
function render_eod_ticker(type, target, value, evolution = {}){
    if(!target) return false;

    // Display settings
    // ndap - number of digits after decimal point (base value)
    // ndape - (evolution value)
    let ndap = eod_display_settings.ndap,
        ndape = eod_display_settings.ndape;

    // The ticker can be without the other half.
    let trg = target.toLowerCase().split('.'),
        full_t_class = '.'+type+'.eod_t_'+trg.join('_'),     // AAPL.US
        t_class = '.'+type+'.eod_t_'+trg[0],                 // AAPL
        $tickers = jQuery(full_t_class+', '+t_class);

    // Display error
    if(!value || value === 'NA') {
        $tickers.text('no result from real time api').closest('.eod_ticker').addClass('error');
        return false;
    }

    // Display data
    $tickers.each(function(){
        let $item = jQuery(this);

        // Check local display settings
        let local_ndap = $item.attr('data-ndap') ? parseInt($item.attr('data-ndap')) : ndap,
            local_ndape = $item.attr('data-ndape') ? parseInt($item.attr('data-ndape')) : ndape;

        // Close value eod_display_settings
        value = parseFloat(value).toFixed( local_ndap );
        $item.text(value);

        // Evolution
        if(!evolution || typeof evolution !== 'object' || value === '-') return;
        if(!Array.isArray(evolution)) evolution = [evolution];
        let list_of_evolution_text = [], e_value;
        for(let e_item of evolution){
            let suffix = e_item.suffix ? e_item.suffix : '';
            e_value = parseFloat( e_item.value ).toFixed( local_ndape );

            if(e_value === "-0") e_value = 0; // fix "-0"
            list_of_evolution_text.push( (e_value > 0 ? '+' : '') + e_value + suffix );
        }
        $item.siblings('.evolution').html( '(<span>' + list_of_evolution_text.join(' ') + '</span>)' );
        $item.closest('.eod_ticker')
            .toggleClass('plus', e_value > 0)
            .toggleClass('equal', !e_value)
            .toggleClass('minus', e_value < 0);
    });
}

// For live
function eod_display_all_live_tickers(){
    // Finding and prepare all tickers. Creating list.
    let eod_t_list = [];

    jQuery(".eod_live").each(function(){
        let target = jQuery(this).attr('data-target');
        if( eod_t_list.indexOf(target) === -1 )
            eod_t_list.push(target);
    });
    
    // Get and display close value
    get_eod_ticker('live', eod_t_list, function(data){
        if(!data || data.error) return false;
        if( !Array.isArray(data) ) data = [data];
        for(let item of data){
            let evolution = null;
            switch (eod_display_settings.evolution_type) {
                case 'abs':
                    evolution = {value: item.change};
                    break;
                case 'percent':
                    evolution = {value: item.change_p, suffix: '%'};
                    break;
                case 'both':
                    evolution = [
                        {value: item.change},
                        {value: item.change_p, suffix: '%'}
                    ];
                    break;
            }

            render_eod_ticker('eod_live', item.code, item.close, evolution);
        }
    });
}

// For historical
function eod_display_all_historical_tickers(){
    // Finding and prepare all tickers. Creating list.
    let eod_t_list = [];

    jQuery(".eod_historical").each(function(){
        let target = jQuery(this).attr('data-target');
        if( eod_t_list.indexOf(target) === -1 )
            eod_t_list.push(target);
    });
    
    // Get and display close value
    get_eod_ticker('historical', eod_t_list, function(data){
        if(!data || data.error || !Array.isArray(data)) return false;
        for(let item of data){
            let evolution = null;
            if(item.change_p !== '' && item.change !== '') {
                switch (eod_display_settings.evolution_type) {
                    case 'abs':
                        evolution = {value: item.change};
                        break;
                    case 'percent':
                        evolution = {value: item.change_p, suffix: '%'};
                        break;
                    case 'both':
                        evolution = [
                            {value: item.change},
                            {value: item.change_p, suffix: '%'}
                        ];
                        break;
                }
            }

            render_eod_ticker('eod_historical', item.code+'.'+item.exchange_short_name, item.close, evolution);
        }
    });
}

// For realtime
function eod_init_realtime_tickers(){
    // Finding and prepare all realtime tickers. Creating list.
    let eod_rt_list = {};
    for(let type in ws_eod) eod_rt_list[type] = [];
    jQuery(".eod_realtime").each(function(){
        let target = jQuery(this).attr('data-target'),
            [code, type] = target.toLowerCase().split('.');
            
        // Check availability, exclude duplication
        if(type && eod_rt_list[type] && eod_rt_list[type].indexOf( code ) === -1)
           eod_rt_list[type].push(code); 
    });

    // Add websocket listeners
    for(let type in eod_rt_list){
        if( !eod_rt_list[type].length ) continue;

        for(let target of eod_rt_list[type]){
            let ws_data = check_ws_eod_data_item(type, target);
            ws_data.listeners['ticker'] = function(res){
                if(res.p || res.a) render_eod_ticker('eod_realtime', res.s+'.'+res.type, res.p ? res.p : res.a);
            };
        }
    }
}

/* =========================================
              display converter
   ========================================= */
function eod_display_converters( $items = false ) {
    if($items && !($items instanceof jQuery)) return;
    if(!$items) $items = jQuery(".eod_converter");

    $items.each(function(){
        eod_display_converter_item( jQuery(this) );
    });
}

/**
 * Prepare the converter item. Create interface elements and add listeners.
 * @param $converter
 */
function eod_display_converter_item( $converter ){
    if(!($converter instanceof jQuery)) return;
    $converter = $converter.eq(0);

    // Check the data-whitelist attribute and move to the converter data
    let whitelist = $converter.attr('data-whitelist') ? $converter.attr('data-whitelist').split(', ') : [];
    $converter.data('whitelist', whitelist).removeAttr('data-whitelist');

    // (HANDLER FUNCTION) Swap currency items
    const swap_currency = function(){
        $converter.addClass('paused');

        let $l = $converter.find('label[data-type]');
        if($l.length < 2) return;
        let $parents = [$l.eq(0).parent(), $l.eq(1).parent()];
        $parents[0].prepend( $l.eq(1) );
        $parents[1].prepend( $l.eq(0) );

        // Swap ratio items in converter data
        let r = $converter.data('live_ratio');
        r._pair = [r._pair[1], r._pair[0]];
        $converter.data('live_ratio', r);

        // Refresh converter
        $converter.removeClass('paused');
        eod_refresh_converter( $converter );
    }

    // Input listeners
    $converter.find('input[type=number]').focusin(function(){
        $converter.addClass('paused');
    }).focusout(function(){
        // Protect from empty main input
        if( jQuery(this).parent().hasClass('main') && !jQuery(this).val() )
            jQuery(this).val(1);

        // Unpause converter
        $converter.removeClass('paused');
        eod_refresh_converter( $converter );
    }).keyup(function(event) {
        // Event for press Enter
        if (event.keyCode === 13) {
            $converter.removeClass('paused');
            eod_refresh_converter( $converter );
            jQuery(this).blur();
        }
    }).on('input', function(){
        jQuery(this).parent().addClass('main').siblings().removeClass('main');
    });

    // Lock button
    $converter.find('label:lt(2)').each(function(){
        if( jQuery(this).parent().hasClass('label_row') ) return;

        // Wrap label and add button
        let $lock = jQuery('<span class="lock"></span>');
        $lock.on('click', function(){
            if(jQuery(this).parent().hasClass('.main')) return;
            $converter.children('.first, .second').toggleClass('main');
            // Add value to empty main input
            let $main_input = $converter.find('.main input[type=number]');
            if(!$main_input.val()) {
                $main_input.val(1);
                $converter.find('> div:not(.main) input[type=number]').val('');
            }
        });
        jQuery(this).wrap('<div class="label_row"></div>').parent().append($lock)
    });
    // Swap button
    if( $converter.find('> .swap').length === 0 ){
        let $swap = jQuery('<span class="swap"></span>');
        if($converter.hasClass('changeable'))
            $swap.on('click', swap_currency);
        $converter.append($swap);
    }

    // The non-changeable version lacks some features
    if(!$converter.hasClass('changeable')){
        eod_run_converter( $converter );
        return;
    }

    // Label click listener
    $converter.find('label:lt(2)').click(function(){
        let $label = jQuery(this),
            $converter = $label.closest('.eod_converter'),
            $select = $label.parent().siblings('.select');

        // (HANDLER FUNCTION) Hide select list of targets
        const hide_select_lists = (() => {
            $converter.removeClass('paused');
            $converter.find('.select').hide();

            // Remove outside click listener
            document.removeEventListener('click', click_outside_select_list, true);
        });

        // (HANDLER FUNCTION) Click detection outside of list
        const click_outside_select_list = ((e) => {
            let $select = $label.parent().siblings('.select'),
                within = e.composedPath().includes( $select[0] );

            if (!within) hide_select_lists();
        });

        // Stop converter and hide lists
        hide_select_lists();
        $converter.addClass('paused');

        // Show hidden select list or create new
        if( $select.length > 0 ) {
            $select.show();
        } else {
            // Create new select box
            $select = jQuery('<div class="select"></div>');
            let $input = jQuery('<input placeholder="find currency ..." type="text">').appendTo($select),
                $list = jQuery('<ul></ul>').appendTo($select);

            // Add custom scrollbar to the targets list
            if(typeof SimpleBar === 'function')
                new SimpleBar($list[0], {});

            // Bind search of currencies
            $input.keyup( jQuery.debounce(300, function() {
                let s = $input.val().toUpperCase(),
                    $container = $input.next(),
                    codes_list = [];

                // Reset old result
                if($container.find('.simplebar-content').length)
                    $container = $container.find('.simplebar-content');
                $container.html('');

                // Ignore empty search for non-whitelist
                if (!whitelist.length && !s) return;

                // Create array of codes
                // By whitelist
                if (whitelist.length) {
                    for (let target of whitelist)
                        if (target.toUpperCase().includes(s))
                            codes_list.push(target.split('.'));
                // By full list
                } else {
                    for (let type of Object.keys(eod_service_data.converter_targets))
                        for (let code of eod_service_data.converter_targets[type])
                            if ((code + '.' + type).toUpperCase().includes(s))
                                codes_list.push([code, type]);
                }

                // Sort
                codes_list.sort(function(a, b) {
                    if(a[0].toUpperCase() === s)
                        return -1;
                    else if(b[0].toUpperCase() === s)
                        return 1;
                    return a[0].localeCompare(b[0]);
                })

                // Add item to DOM
                for (let item of codes_list)
                    $container.append('<li>' +
                                    '<span class="code">'+item[0]+'</span>' +
                                    '<span class="ex">'+item[1].toUpperCase()+'</span>' +
                                '</li>')

            }));
            $input.trigger('keyup');

            // Add select code listener
            $select.on('click', 'ul li', function(){
                let code = jQuery(this).children('.code').text(),
                    type = jQuery(this).children('.ex').text().toLowerCase(),
                    $select = jQuery(this).closest('.select'),
                    $label = $select.siblings('.label_row').children('label[data-type]'),
                    $other_label = $select.parent().siblings('*:lt(1)').find('label[data-type]'),
                    target = $label.text() + (type === 'cc' ? '-USD' : 'USD');

                // Ignore event if code not changed
                if(code === $label.text()) return;

                // Hide select list
                hide_select_lists();

                // Reset non-main input
                $converter.find('> div:not(.main) input[type=number]').val('');

                // Another currency may already have such a code, need to swap them.
                if($other_label.text() === code) {
                    swap_currency();
                }else{
                    // Remove old WS listener if other converters don't need it
                    // Looking for the same label
                    if( jQuery('.eod_converter label[data-slug="'+$label.attr('data-slug')+'"]').length <= 1 )
                        remove_ws_eod_data_item(type, target, 'converter');

                    // Set new code and correct font-size
                    $label.text( code ).attr('data-type', type);
                    let greatest = $other_label.text().length;
                    if(greatest < code.length) greatest = code.length;
                    if(greatest > 5)
                        $converter.find('.label_row').css({fontSize: greatest > 10 ? '0.4em' : '0.7em'});
                    else
                        $converter.find('.label_row').css({fontSize: ''});

                    // Refresh converter
                    eod_run_converter( $converter );
                }
            });

            // Add select to DOM
            $label.parent().after( $select );
        }
        // Focus on search input
        $select.children('input').focus();

        // Add outside click listener
        let events = jQuery._data(document, "events"),
            handler_is_exist = false;
        for(let e of events.click) handler_is_exist = handler_is_exist || e.handler === click_outside_select_list;
        if(!handler_is_exist) document.addEventListener('click', click_outside_select_list, true);
    });

    eod_run_converter( $converter );
}

/**
 * Use selected currency to get ratio values using the EOD API
 * @param $converter
 */
function eod_run_converter( $converter ){
    if(!($converter instanceof jQuery)) return;
    $converter = $converter.eq(0);
    $converter.data('live_ratio', {'_pair': [false,false]});

    // Get pairs of targets, types and slugs
    let $labels = $converter.find('label:lt(2)'),
        codes = [],
        types = [],
        targets = [],
        slugs = [];
    $labels.each(function(){
        codes.push( jQuery(this).text() );
        types.push( jQuery(this).attr('data-type') );
    });
    if(!codes[0] || !codes[1] || !types[0] || !types[1]) return;

    /**
     * For conversion, not one but two tickers may be required
     * Any target has a pair with USD, so we use USD to link
     * USD is placed second in the target
     * Cryptocurrency through a dash, and currency all together
     * And add type to the end (.CC, .FOREX)
     * Create a target and check it through the API
     */

    for(let i=0; i<2; i++){
        if( types[i].toLowerCase() === 'cc' ) {
            targets.push(codes[i] + '-USD.CC');
            slugs.push(codes[i] + '_USD_CC');
        } else {
            targets.push(codes[i] + 'USD.FOREX');
            slugs.push(codes[i] + 'USD_FOREX');
        }
        // Add slug to label
        $labels.eq(i).attr('data-slug', slugs[i]);
    }

    // Set pair of slugs into ratio data
    // This will help determine what needs to be divided into what
    $converter.data('live_ratio', {'_pair': slugs});

    // Get start value by live API
    get_eod_ticker('live', targets, function(data) {
        if (!data || data.error) return false;

        // Set ratio in $converter data and update numbers
        let ratio = $converter.data('live_ratio');
        for(let item of data){
            if(!item || !item.close) continue;
            let slug = item.code.replace(/(-)|(\.)/g, '_');
            ratio[slug] = item.close;
        }
        $converter.data('live_ratio', ratio);
        eod_refresh_converter( $converter );
    });

    // Add websocket listeners for realtime data updating
    for(let i=0; i<2; i++) {
        let ws_data = check_ws_eod_data_item(types[i], targets[i].split('.')[0]),
            slug = slugs[i];
        ws_data.listeners['converter'] = function (res) {
            if (!res.p && !res.a) return;

            let $converters = jQuery('.eod_converter label[data-slug="'+slug+'"]').closest('.eod_converter');
            if($converters.length === 0) return;

            $converters.each(function(){
                let ratio = jQuery(this).data('live_ratio');
                ratio[slug] = parseFloat( res.p ? res.p : res.a );
                // Save ratio and refresh converter
                jQuery(this).data('live_ratio', ratio);
                eod_refresh_converter( jQuery(this) );
            });
        };
    }
}

/**
 * Use saved conversion rate to calculate and refresh displayed currency values
 * @param $converter
 */
function eod_refresh_converter( $converter ){
    if(!($converter instanceof jQuery)) return;
    $converter = $converter.eq(0);

    // Ignore paused converter
    if( $converter.hasClass('paused') ) return;

    let ratio = $converter.data('live_ratio'),
        $changing_input =  $converter.find('> div:not(.main) input[type=number]');
    // If ratio pair not contain two slugs, then not main input must be cleared.
    if(ratio._pair.indexOf(false) > -1){
        $changing_input.val('');
        return;
    }

    // Wait value
    if(!ratio[ ratio._pair[0] ] || !ratio[ ratio._pair[1] ]) return;

    // Calc and change value
    let ratio_value = ratio[ ratio._pair[0] ] / ratio[ ratio._pair[1] ],
        main_val = parseFloat( $converter.find('.main input[type=number]').val() ),
        new_value = $changing_input.parent().hasClass('first') ? (main_val / ratio_value) : (main_val * ratio_value);
    $changing_input.val( new_value > 1 ? new_value.toFixed(2) : new_value.toFixed(5) );
}


/* =========================================
     loading and displaying fundamental data
   ========================================= */
function eod_display_fundamental_data(){
    // Fundamental data include simple list data (.eod_fd_list) and financials tables (.eod_financials)
    // Finding and prepare all tickers. Creating list.
    let eod_t_list = [];

    jQuery(".eod_fd_list, .eod_financials").each(function(){
        let target = jQuery(this).attr('data-target');

        // Common ticker
        if( eod_t_list.indexOf(target) === -1 )
            eod_t_list.push(target);
    });

    // Get Fundamental Data and display
    for(let target of eod_t_list) {
        // Find fundamental data elements
        let trg = target.toLowerCase().split('.'),
            $fd_list = jQuery('.eod_fd_list.eod_t_'+trg.join('_')),
            $financials_table = jQuery('.eod_financials.eod_t_'+trg.join('_'));

        // Log
        eod_debug.addTimePoint('AJAX request to the fundamental data API for ('+target+')',{
            type: 'fundamental',
            slug: target,
            moment: 'start'
        });

        // Loading animation
        $fd_list.addClass('eod_loading');
        $financials_table.addClass('eod_loading');
        get_eod_fundamental(target, function (data) {
            // Log
            eod_debug.addTimePoint('AJAX response from the fundamental data API for ('+target+'), render financials table and list',{
                type: 'fundamental',
                slug: target,
                moment: 'end'
            });

            if(!data || data.error) {
                // Hide loading animation
                $fd_list.removeClass('eod_loading');
                $financials_table.removeClass('eod_loading');
                return false;
            }

            // Render data
            // for simple data list
            $fd_list.each(function(){
                jQuery(this).find('> li').each(function(){
                    let $li = jQuery(this),
                        slug = $li.attr('data-slug');
                    if(!slug) return;

                    // Find value in data
                    let path = slug.split('->'),
                        value = data;
                    for(let key of path) {
                        if (typeof value === 'object' && value !== null) {
                            if(!value.hasOwnProperty(key) || value[key] === undefined) return;
                            value = value[key];
                        }
                    }

                    // Display string or number value as string
                    if( ['number', 'string', 'undefined'].indexOf(typeof value) > -1 ) {
                        $li.append('<span>' + abbreviateNumber(value) + '</span>');

                    // No data
                    }else if(value === null){
                        if(eod_display_settings.fd_no_data_warning)
                            $li.append('<span class="eod_error">no data</span>');

                    // Display object as table
                    }else if(typeof value === 'object'){
                        // Empty object
                        if(Object.keys(value).length === 0){
                            if(eod_display_settings.fd_no_data_warning)
                                $li.append('<span class="eod_error">empty list</span>');
                            return;
                        }

                        let Table = new EodCreateTable({
                                type: 'table'
                            });

                        // The parameter item may contain a title in its own key
                        let has_row_name = !Array.isArray(value);

                        // Table header
                        let [first_item_key] = Object.keys(value);
                        if( typeof( value[first_item_key] ) === 'object' ) {
                            if(has_row_name){
                                Table.set_header( ['', ...Object.keys(value[first_item_key])] );
                            }else{
                                Table.set_header( Object.keys(value[first_item_key]) );
                            }
                        }

                        // Table body
                        for (let [index, item] of Object.entries(value)) {
                            let values_list = typeof item === 'object' ? Object.values(item) : [item];
                            if(has_row_name){
                                Table.add_row( [index, ...values_list] );
                            }else{
                                Table.add_row( values_list );
                            }
                        }

                        // Show table
                        let $wrapper = jQuery('<div class="eod_table_wrapper"></div>');
                        $wrapper.append( Table.get_table() )

                        // Add custom scrollbar
                        if(typeof SimpleBar === 'function')
                            new SimpleBar( $wrapper[0] );

                        $li.append( $wrapper );
                    }
                });
                // Hide loading animation
                jQuery(this).removeClass('eod_loading');
            });

            // for financials tables
            $financials_table.each(function(){
                // Save data in element
                jQuery(this).data('data', data);

                // Render table
                eod_render_financial_table( jQuery(this) );
                // Hide loading animation
                jQuery(this).removeClass('eod_loading');
            });
        });
    }
}

/* =========================================
           render financial table
   ========================================= */
function eod_render_financial_table( $table_box ) {
    let financials_list = $table_box.data('data');
    if (!financials_list) return;

    let Table = new EodCreateTable({
            type: 'div'
        }),
        selected_timeline = $table_box.data('selected_timeline'),
        group = $table_box.attr('data-group') ? $table_box.attr('data-group').split('->') : false,
        parameters = $table_box.attr('data-cols'),
        years = $table_box.attr('data-years');

    if (!group || !parameters) return;

    // The source data may contain separate arrays: 'yearly', 'quarterly'.
    // Or without them, but assuming that the list of data has the same gradation
    // either by 'yearly' or by 'quarterly'.
    // This parameter determines which key to use or how interpret date keys in the list.
    let timeline_type = eod_display_settings.prop_naming['_timeline_' + group[group.length - 1]];

    if( !selected_timeline )
        selected_timeline = timeline_type === 'both' ? 'yearly' : timeline_type;


    // Define data group
    while (group.length) {
        let key = group.shift();
        if (financials_list[key]) financials_list = financials_list[key];
        else break;
    }

    // Define currency. Not every group contain parameter.
    let currency = financials_list.currency_symbol;

    // Financials list may contain separate arrays: 'yearly', 'quarterly'.
    // Select specific
    if (timeline_type === 'both'){
        if (financials_list[selected_timeline]) financials_list = financials_list[selected_timeline];
        else return;
    }

    // If 'currency_symbol' not found select first item and get currency.
    // This method cannot be used as the main one because not every item has currency/currency_symbol.
    if(!currency) currency = Object.values( financials_list )[0].currency;

    // Prepare time interval
    if(years){
        years = years.split('-');
        if(years.length < 2) years = false;
    }

    // Add timeline toggle
    if( timeline_type === 'both' && $table_box.children('.eod_toggle').length === 0 ) {
        let $toggle = jQuery('<button class="eod_toggle timeline">\
                                <span>Annual</span>\
                                <span>Quarterly</span>\
                              </button>');

        // Toggle default option
        $toggle.find('span').eq( selected_timeline === 'quarterly' ? 1 : 0 ).addClass('selected');

        // Toggle event
        $toggle.click(function (e) {
            let $target = jQuery(e.target);
            if( $target.hasClass('selected') ) return;
            jQuery(this).toggleClass('on');
            jQuery(this).find('span').toggleClass('selected');
            $table_box.data('selected_timeline', jQuery(this).hasClass('on') ? 'quarterly' : 'yearly');
            eod_render_financial_table($table_box);
        });
        $table_box.prepend($toggle);
    }

    // Remove old tables
    $table_box.find('.eod_tbody').html('');

    // First header row
    let dates = [];
    for(let [date, item] of Object.entries( financials_list )){
        let d = new Date( date ),
            y = d.getFullYear(),
            m = d.getMonth()+1,
            display_date = '';

        // Filter by date interval
        if(years && !( (!years[0] || years[0] <= y) && (!years[1] || y <= years[1]) ))
            continue;

        if(selected_timeline === 'yearly')
            display_date = y;
        else if(selected_timeline === 'quarterly'){
            display_date = 'Q' + Math.ceil(m/3) + " '" + y;
        }

        dates.push('<div>'+ display_date +'</div>');
    }
    Table.set_header( ['<span>Currency: '+currency+'</span>', ...dates.reverse()] );

    // Another rows of stats
    for(let parameter of parameters.split(';')){
        // First column of parameters names
        let display_name = eod_display_settings.prop_naming[parameter];
        if(!display_name) display_name = parameter;
        display_name = '<span title="'+ display_name +'">'+ display_name +'</span>';

        // Another columns of parameters values
        let cols = [];
        for(let [date, item] of Object.entries( financials_list )){
            let value = '',
                d = new Date( date ),
                y = d.getFullYear();

            // Filter by date interval
            if(years && !( (!years[0] || years[0] <= y) && (!years[1] || y <= years[1]) ))
                continue;

            if(item[parameter] === 0 || item[parameter]) value = abbreviateNumber(item[parameter]);
            cols.push( (value === '' ? '-' : value) );
        }

        Table.add_row( [display_name, ...cols.reverse()] );
    }

    // Show table
    $table_box.find('.eod_tbody').replaceWith( Table.get_tbody() );
}

function getTextWidth(text, font) {
    // re-use canvas object for better performance
    const canvas = getTextWidth.canvas || (getTextWidth.canvas = document.createElement("canvas"));
    const context = canvas.getContext("2d");
    context.font = font;
    const metrics = context.measureText(text);
    return metrics.width;
}

function getCssStyle(element, prop) {
    return window.getComputedStyle(element, null).getPropertyValue(prop);
}

function getCanvasFontSize(el = document.body) {
    const fontWeight = getCssStyle(el, 'font-weight') || 'normal';
    const fontSize = getCssStyle(el, 'font-size') || '16px';
    const fontFamily = getCssStyle(el, 'font-family') || 'Times New Roman';

    return `${fontWeight} ${fontSize} ${fontFamily}`;
}

class EodCreateTable {
    constructor(p) {
        const _this = this;
        _this.header = [];
        _this.rows = [];
        _this.type = p.type ? p.type : 'div';
        _this.template = {
            table: {
                table: 'table',
                tbody: 'tbody',
                row: 'tr',
                header: 'th',
                cell: 'td'
            },
            div: {
                table: 'div',
                tbody: 'div',
                row: 'div',
                header: 'div',
                cell: 'div'
            }
        }[_this.type];
    }

    set_header( list ) {
        const _this = this;
        _this.header_list = list;
    }

    add_row( list ) {
        const _this = this;
        _this.rows.push( list );
    }

    get_tbody() {
        const _this = this;
        let tag = _this.template,
            $tbody = jQuery('<'+tag.tbody+' class="eod_tbody"></'+tag.tbody+'>');

        // Header
        if ( Array.isArray( _this.header_list ) && _this.header_list.length ){
            let $header = jQuery('<'+tag.row+' class="header"></'+tag.row+'>');
            for (let item of _this.header_list) {
                $header.append('<'+tag.header+'>' + item + '</'+tag.header+'>');
            }
            $tbody.append($header);
        }

        // Body
        for( let row of _this.rows ){
            let $row = jQuery('<'+tag.row+'></'+tag.row+'>');
            for( let item of row ){
                $row.append('<'+tag.cell+'>' + item + '</'+tag.cell+'>');
            }
            $tbody.append($row);
        }

        return $tbody;
    }

    get_table() {
        let tag = this.template,
            $table = jQuery('<'+tag.table+' class="eod_table"></'+tag.table+'>');
        $table.append( this.get_tbody() )
        return $table;
    }

    //     max_first_col_width = 0,
    //     font_styles = 'normal 12px ' + getCssStyle(document.body, 'font-family') || 'Times New Roman';

    // for (let [index, item] of Object.entries(value)) {
    //     let $row = jQuery('<div><div>'+index+'</div></div>'),
    //         first_col_width = getTextWidth( index, font_styles );
    //
    //     if( first_col_width > max_first_col_width ) max_first_col_width = first_col_width;
    // }
    //
    // max_first_col_width += 15;
    // $table.find('.eod_tbody > div > div:first-child').css({'width': max_first_col_width + 'px'});
}