<?php
/**
 * BuddyPress Moderation Tools:- User Activity Gate.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\User\Gate;


// Exit if files accessed directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles restrictions on activity/activity comment posting.
 */
class User_Activity_Gate {
	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		add_filter( 'bp_activity_can_comment', array( $this, 'is_active' ) );
		add_filter( 'bp_activity_can_comment_reply', array( $this, 'is_active' ) );
		add_filter( 'bp_activity_user_can_delete', array( $this, 'is_active' ) );

		// Check for compose action, redirect to inbox instead with message.
		$this->setup_update_hooks();

		// Hide from activity feed.
		// add_filter( 'bp_activity_get_where_conditions', array( $this, 'exclude_activity' ) );
	}

	/**
	 * Is user active?
	 *
	 * @param bool $can can do the action.
	 *
	 * @return bool
	 */
	public function is_active( $can ) {

		if ( bpmts_is_loggedin_user_hidden() && bpmts_get_option( 'user_disable_activity_commenting' ) ) {
			return false;
		}

		return $can;
	}


	/**
	 * Buddypress does not have permission system, so let us do it the other way.
	 */
	private function setup_update_hooks() {
		// only if needed.
		if ( ! bpmts_get_option( 'user_disable_activity_posting' ) ) {
			return;
		}

		add_action( 'bp_before_activity_post_form', array( $this, 'before_post_form' ), 0 );
		add_action( 'bp_after_activity_post_form', array( $this, 'after_post_form' ), 10001 );
	}


	/**
	 * Buffer the form.
	 */
	public function before_post_form() {

		if ( ! bpmts_is_loggedin_user_hidden() ) {
			return;
		}

		ob_start();// start output buffering.
	}

	/**
	 * Throw away the buffer.
	 */
	public function after_post_form() {

		if ( ! bpmts_is_loggedin_user_hidden() ) {
			return;
		}

		 ob_end_clean() ;// discard buffer.
		echo '';
	}
}
