<?php
/**
 * Admin Settings Pages for the Comment.
 * @package    ModerationTools
 * @subpackage Reportable_Types\Comment_Type
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\Comment_Type;

// Exit if the file is accessed directly over web.
use Press_Themes\PT_Settings\Panel;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builder for pages panel.
 */
class Comment_Type_Settings_Panel {
	/**
	 * Add panel settings.
	 *
	 * @param Panel  $panel panel object.
	 * @param string $comment_type Comment type.
	 * @label string $label Comment label.
	 */
	public static function build( Panel $panel, $comment_type = 'comment', $label ) {

		$settings = bpmts_get_default_settings();

		$defaults = array(
			"{$comment_type}_auto_hide"                => 1,
			"{$comment_type}_threshold"                => 5,
			"{$comment_type}_hide_type"                => 'all',
			"{$comment_type}_notify_admin_on_report"   => 1,
			"{$comment_type}_admin_reported_subject"   => '',
			"{$comment_type}_admin_reported_message"   => '',
			"{$comment_type}_notify_admin_on_hide"     => 1,
			"{$comment_type}_admin_hidden_subject"     => '',
			"{$comment_type}_admin_hidden_message"     => '',
			"{$comment_type}_notify_author_on_hide"    => 1,
			"{$comment_type}_author_hidden_subject"    => '',
			"{$comment_type}_author_hidden_message"    => '',
			"{$comment_type}_notify_author_on_restore" => 1,
			"{$comment_type}_author_restored_subject"  => '',
			"{$comment_type}_author_restored_message"  => '',
			"{$comment_type}_notify_author_on_delete"  => 1,
			"{$comment_type}_author_deleted_subject"   => '',
			"{$comment_type}_author_deleted_message"   => '',
		);

		$singular_name = $label;

		$doc_link = 'https://buddydev.com/docs/buddypress-moderation-tools/settings-comment-type';

		$panel->add_section( "report-type-{$comment_type}-general-settings", __( 'General', 'buddypress-moderation-tools' ) )
		      ->add_field( array(
			      'name'    => "{$comment_type}_auto_hide",
			      'label'   => sprintf( __( 'Auto hide %s?', 'buddypress-moderation-tools' ), $singular_name ),
			      'type'    => 'radio',
			      'default' => $defaults["{$comment_type}_auto_hide"],
			      'options' => array(
				      1 => __( 'Yes', 'buddypress-moderation-tools' ),
				      0 => __( 'No', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => sprintf( __( 'If enabled, reported %s will be automatically hidden on reaching threshold.', 'buddypress-moderation-tools' ), $singular_name ),
		      ) )
		      ->add_field( array(
			      'name'    => "{$comment_type}_threshold",
			      'label'   => sprintf( __( '%s hiding threshold ', 'buddypress-moderation-tools' ), $singular_name ),
			      'type'    => 'number',
			      'default' => $defaults["{$comment_type}_threshold"],
			      'desc'    => sprintf( __( 'How many users should report the %s before it gets hidden?', 'buddypress-moderation-tools' ), $singular_name ),
		      ) )
		      ->add_field( array(
			      'name'    => "{$comment_type}_hide_type",
			      'label'   => __( 'Hide for', 'buddypress-moderation-tools' ),
			      'type'    => 'radio',
			      'default' => $defaults["{$comment_type}_hide_type"],
			      'options' => array(
				      'all'      => __( 'All', 'buddypress-moderation-tools' ),
				      'reporter' => __( 'Reporters', 'buddypress-moderation-tools' ),
			      ),
			      'desc'    => sprintf( __( 'Hides the %s from logged in reporters.', 'buddypress-moderation-tools' ), $singular_name ),
		      ) );

		// Notification.
		$section = $panel->add_section( "report-comment-type-{$comment_type}-new-report-admin-notification", __( 'Admin new report notification', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "{$comment_type}_notify_admin_on_report",
			'label'   => __( 'Notify admin on new report?', 'buddypress-moderation-tools' ),
			'type'    => 'radio',
			'default' => $defaults[ "{$comment_type}_notify_admin_on_report" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'Notify admin if %s is reported.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "{$comment_type}_admin_reported_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "{$comment_type}_admin_reported_subject" ],
		) )->add_field( array(
			'name'    => "{$comment_type}_admin_reported_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "{$comment_type}_admin_reported_message" ],
		) );

		// Notification.
		$section = $panel->add_section( "report-comment-type-{$comment_type}-admin-threshold-notification", __( 'Admin notification on hiding group', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "{$comment_type}_notify_admin_on_hide",
			'label'   => sprintf( __( 'Notify admin when %s is hidden?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "{$comment_type}_notify_admin_on_hide" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'Admin will only be notified when a %s is hidden.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "{$comment_type}_admin_hidden_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "{$comment_type}_admin_hidden_subject" ],
		) )->add_field( array(
			'name'    => "{$comment_type}_admin_hidden_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "{$comment_type}_admin_hidden_subject" ],
		) );

		// User report on user hide
		// Notification.
		$section = $panel->add_section( "report-comment-type-{$comment_type}-author-threshold-notification", __( 'Author/creator notification on hiding', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "{$comment_type}_notify_author_on_hide",
			'label'   => sprintf( __( 'Notify author when their %s is hidden?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "{$comment_type}_notify_author_on_hide" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'User will be notified when their %s is hidden.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "{$comment_type}_author_hidden_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "{$comment_type}_author_hidden_subject" ],
		) )->add_field( array(
			'name'    => "{$comment_type}_author_hidden_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "{$comment_type}_author_hidden_message" ],
		));

		// User restore notification.
		// Notification.
		$section = $panel->add_section( "report-comment-type-{$comment_type}-author-notification-restore", __( 'Author Notification on restoration', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "{$comment_type}_notify_author_on_restore",
			'label'   => sprintf( __( 'Notify author when their %s is restored?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "{$comment_type}_notify_author_on_restore" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'User will be notified when their %s is restored.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "{$comment_type}_author_restored_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "{$comment_type}_author_restored_subject" ],
		) )->add_field( array(
			'name'    => "{$comment_type}_author_restored_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "{$comment_type}_author_restored_message" ],
		) );


		// User restore notification.
		// Notification.
		$section = $panel->add_section( "report-comment-type-{$comment_type}-notification-delete", __( 'Author notification on delete', 'buddypress-moderation-tools' ) );

		$section->add_field( array(
			'name'    => "{$comment_type}_notify_author_on_delete",
			'label'   => sprintf( __( 'Notify user when their %s is deleted?', 'buddypress-moderation-tools' ), $singular_name ),
			'type'    => 'radio',
			'default' => $defaults[ "{$comment_type}_notify_author_on_delete" ],
			'options' => array(
				1 => __( 'Yes', 'buddypress-moderation-tools' ),
				0 => __( 'No', 'buddypress-moderation-tools' ),
			),
			'desc'    => sprintf( __( 'User will be notified when their %s is deleted by admin.', 'buddypress-moderation-tools' ), $singular_name ),
		) );

		$section->add_field( array(
			'name'    => "{$comment_type}_author_deleted_subject",
			'label'   => _x( 'Subject', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'text',
			'default' => $defaults[ "{$comment_type}_author_deleted_subject" ],
		) )->add_field( array(
			'name'    => "{$comment_type}_author_deleted_message",
			'label'   => _x( 'Message', 'Admin settings', 'buddypress-moderation-tools' ),
			'type'    => 'rawtext',
			'default' => $defaults[ "{$comment_type}_author_deleted_message" ],
		) );
	}
}

