<?php
/**
 * BuddyPress Moderation Tools:- Activity Message Builder.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Activity
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Activity\Messages;

use PressThemes\ModerationTools\Messages\Message_Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Activity message builder.
 */
class Activity_Message_Builder extends Message_Builder {

	/**
	 * Token map.
	 *
	 * @param \BP_Activity_Activity $item item.
	 *
	 * @return array
	 */
	public function item_tokens_map( $item ) {
		return array(
			'{item.type}' => __( 'activity', 'buddypress-moderation-tools' ),
			'{item.label}' => $item->content,
			'{item.url}'   => bp_activity_get_permalink( $item->id, $item ),
		);
	}
}

