<?php
/**
 * ReportAbuse:- Activity Comment UI Helper.
 *
 * @package    ReportAbuse
 * @subpackage User
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

namespace PressThemes\ModerationTools\Reportable_Types\BuddyPress\Activity_Comment\Handlers;

// Exit if files access directly over web.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Buttons & Messages management.
 */
class Activity_Comment_UI_Helper {

	/**
	 * Boot this class.
	 */
	public static function boot() {
		$self = new self();
		$self->setup();
	}

	/**
	 * Setup hooks callbacks
	 */
	public function setup() {
		// Add Buttons.
		// unlike works for both the cases.
		add_action( 'bp_activity_comment_options', array( $this, 'add_button' ), 1001 );
	}

	/**
	 * Add button to activity entry.
	 */
	public function add_button() {

		if ( bpmts_user_can_report() ) {
			bpmts_report_button( array(
				'item_id'     => bp_get_activity_comment_id(),
				'item_type'   => 'bp_acomment',
				'context'     => 'activity_reply',
				'context_id'  => bp_get_activity_comment_id(),
				'use_wrapper' => false,
				'link_class'  => 'bp-secondary-action',
			) );
		}
	}
}
