<?php
/**
 * Model class for queue items table
 *
 * @package buddypress-moderation-tools
 */

namespace PressThemes\ModerationTools\Models;

use PressThemes\ModerationTools\Schema\Schema;

/**
 * Class Queue_Item
 *
 * @property int $id Queue id.
 * @property int $user_id user id.
 * @property int $item_id Item id.
 * @property string $item_type Item type.
 * @property string $context Context.
 * @property int $context_id Context id.
 * @property int $is_new Is new for moderation or not.
 * @property int $is_hidden Is item hidden?
 * @property string $created_at Date added to queue.
 * @property string $updated_at Date updated.
 * @property int $total_reports_count Total reports count on item.
 * @property int $current_reports_count Current reports count.
 */
class Queue extends Model {

	/**
	 * Get the table name.
	 *
	 * @return null|string
	 */
	public static function table() {
		return Schema::table( 'queue' );
	}

	/**
	 * Table schema.
	 *
	 * @return array
	 */
	public static function schema() {

		return array(
			'id'                    => 'integer',
			'user_id'               => 'integer',
			'item_id'               => 'integer',
			'item_type'             => 'string',
			'context_id'            => 'integer',
			'context'               => 'string',
			'is_new'                => 'integer',
			'is_hidden'             => 'integer',
			'total_reports_count'   => 'integer',
			'current_reports_count' => 'integer',
			'created_at'          => 'datetime',
			'updated_at'          => 'datetime',
		);
	}
}
