<?php
/**
 * Short Description
 *
 * @package    bp29_dev
 * @subpackage ${NAMESPACE}
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

use PressThemes\ModerationTools\Models\Category;


/**
 * Report button
 *
 * @param array $args array of values like item id, context etc.
 */
function bpmts_report_button( $args = array() ) {
	echo bpmts_get_report_button( $args );
}

/**
 * Get report button
 *
 * @param array $args attribute to button.
 *
 * @return string
 */
function bpmts_get_report_button( $args = array() ) {
	$args = wp_parse_args( $args, array(
		'item_id'       => 0,
		'item_type'     => '',
		'context'       => '',
		'context_id'    => 0,
		'link_class'    => '',
		'wrapper_class' => '',
		'use_wrapper'   => true,
		'wrapper_tag'   => 'div',
	) );

	$args = apply_filters( 'bpmts_report_button_args', $args );

	// Make sure we have item id and type.
	if ( empty( $args['item_id'] ) || empty( $args['item_type'] ) ) {
		return '';
	}

	$label = __( 'Report', 'buddypress-moderation-tools' );

	$use_bp_button_markup = $args['use_wrapper'];
	$wrapper_tag          = $args['wrapper_tag'];
	ob_start();

	?>
	<a href="#" data-item-id="<?php echo esc_attr( $args['item_id'] );?>" data-item-type="<?php echo esc_attr( $args['item_type'] );?>" data-context="<?php echo esc_attr( $args['context'] );?>" data-context-id="<?php echo esc_attr( $args['context_id'] );?>" class="bpmts-report-button <?php echo $args['link_class'];?>"><?php echo $label; ?></a>

    <?php
	$button = ob_get_clean();
	if ( $use_bp_button_markup ) {
		$button = "<{$wrapper_tag} class='bpmts-moderation-button-wrap bpmts-type-{$args['item_type']}-button generic-button {$args['wrapper_class']}'>{$button}</{$wrapper_tag}>";
	}

	return apply_filters( 'bpmts_report_button', $button, $args );
}


/**
 * Get categories dropdown list.
 *
 * @param array $args args.
 *
 * @return string
 */
function bpmts_list_categories( $args = array() ) {

	$defaults = array(
		'name'              => 'category',
		'id'                => '',
		'selected'          => 0,
		'select_label'      => __( 'Select category', 'buddypress-moderation-tools' ),
		'show_select_label' => true,
	);

	$args = wp_parse_args( $args, $defaults );

	if ( ! isset( $args['active'] ) ) {
		$categories = Category::all();
	} elseif ( $args['active'] ) {
		$categories = Category::get_active();
	} else {
		$categories = Category::get( array( 'is_active' => $args['active'], 'per_page' => 0 ) );
	}

	if ( $categories ) {
		$categories = wp_list_pluck( $categories, 'name', 'id' );
	}

	$name    = esc_attr( $args['name'] );
	$id      = esc_attr( $args['id'] );
	$id_attr = $args['id'] ? " id ='{$id}'" : '';

	$html = "<select name='{$name}' " . $id_attr . '>';

	if ( $args['show_select_label'] && $args['select_label'] ) {
		$html .= "<option value='0' " . selected( 0, $args['selected'], false ) . ">{$args['select_label']}</option>";
	}

	foreach ( $categories as $id => $name ) {
		$name = esc_html( $name );
		$html .= "<option value='{$id}' " . selected( $id, $args['selected'], false ) . ">{$name}</option>";
	}

	$html .= '</select>';

	return $html;
}

/**
 * Get the info tag.
 *
 * @param array $args args.
 *
 * @return string
 */
function bpmts_get_hidden_info_box( $args ) {
	$args = wp_parse_args( $args, array(
		'item_id'    => 0,
		'item_type'     => '',
		'link_class'    => '',
		'wrapper_class' => '',
		'use_wrapper'  => true,
	) );

	$label = __( 'Hidden: View Reports', 'buddypress-moderation-tools' );

	$use_bp_button_markup = $args['use_wrapper'];

	if ( empty( $args['item_type'] ) || empty( $args['item_id'] ) ) {
		return '';
	}
	$url = bpmts_admin_get_queue_url(
		array(
			'queue_id'     => 0,
			'bpmts_action' => 'item-report-view',
			'item_type'    => $args['item_type'],
			'item_id'      => $args['item_id'],
		)
	);

	$title = __( 'view reports', 'buddypress-moderation-tools' );

	$button = sprintf( "<a href='%s' title='%s' class='%s bpmts-info-tag-link'>%s</a>", $url, $title, $args['link_class'], $label );

	if ( $use_bp_button_markup ) {
		$button = "<div class='bpmts-info-tag bpmts bpmts-type-{$args['item_type']}-info-tag generic-button {$args['wrapper_class']}'>{$button}</div>";
	}

	return $button;
}
