<?php
/**
 * Category edit form.
 *
 * @package    BuddyPress Moderation Tools
 * @subpackage Admin/category
 * @copyright  Copyright (c) 2018, Brajesh Singh
 * @license    https://www.gnu.org/licenses/gpl.html GNU Public License
 * @author     Brajesh Singh
 * @since      1.0.0
 */

use PressThemes\ModerationTools\Models\Category;

// Do not allow direct access over web.
defined( 'ABSPATH' ) || exit;

?>
<div class="wrap bpmts-cat-page-wrap">
    <h1 class="wp-heading-inline"><?php _e( 'Categories', 'buddypress-moderation-tools' ); ?><a class="page-title-action" href="<?php echo esc_url( $this->url() )?>"><?php _e( 'View all', 'buddypress-moderation-tools' );?></a> </h1>
    <hr class="wp-header-end">
	<?php bpmts_admin_notice(); ?>
	<?php $category = Category::first( array( 'id' => $this->cat_id ) ); ?>
    <div id="col-container" class="wp-clearfix">

        <div id="col-left">
            <div class="col-wrap">
                <div class="form-wrap">
                    <h2><?php echo esc_html( sprintf( __( 'Editing Category "%s"', 'buddypress-moderation-tools' ), $category->name ) ); ?></h2>
                    <form id="bpmts-category-form" method="post" action="" class="bpmts-admin-form bpmts-add-category-form">

						<?php wp_nonce_field( 'bpmts_edit_category' ); ?>

                        <div class="form-field form-required term-name-wrap">
                            <label for="bpmts-name"><?php _e( 'Name', 'buddypress-moderation-tools' ); ?></label>
                            <input name="name" id="bpmts-name" type="text"
                                   value="<?php echo esc_attr( $category->name ); ?>" size="40" aria-required="true">
                            <p> <?php _e( 'Name shown in the dropdown.', 'buddypress-moderation-tools' ); ?></p>
                        </div>

                        <div class="form-field bpmts-cat-form-field-active">
                            <label for="is_active"> <?php _e( 'Active?', 'buddypress-moderation-tools' ); ?></label>
                            <select name="is_active" class="postform">
                                <option value="1" <?php selected( $category->is_active, 1, true ); ?>><?php _e( 'Yes', 'buddypress-moderation-tools' ); ?></option>
                                <option value="0" <?php selected( $category->is_active, 0, true ); ?>><?php _e( 'No', 'buddypress-moderation-tools' ); ?></option>
                            </select>
                            <p><?php _e( "Inactive categories won't be shown to the user.", 'buddypress-moderation-tools' ); ?></p>
                        </div>

                        <p class="submit">
                            <input type="submit" name="submit" id="submit" class="button button-primary"
                                   value="<?php _e( 'Update Category', 'buddypress-moderation-tools' ); ?>">
                        </p>

                        <input type="hidden" name="id" value="<?php echo esc_attr( $category->id ); ?>"/>
                    </form>
                </div>

            </div>
        </div><!-- /col-left -->
    </div>